package cn.com.poc.knowledge.scheduler;


import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.knowledge.constant.KnowledgeConstant;
import cn.com.poc.knowledge.entity.BizKnowledgeDocumentEntity;
import cn.com.poc.knowledge.query.KnowledgeInfosQueryCondition;
import cn.com.poc.knowledge.query.KnowledgeInfosQueryItem;
import cn.com.poc.knowledge.service.BizKnowledgeDocumentService;
import cn.com.poc.knowledge.service.BizKnowledgeInfoService;
import cn.com.poc.message.entity.KnowledgeTrainStatusMessage;
import cn.com.poc.message.service.KnowledgeProducerService;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.DemandKnowledgeService;
import cn.com.poc.thirdparty.resource.demand.ai.constants.KnowledgeTrainStatusConstant;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

@Component
public class KnowledgeInfoScheduler {

    @Resource
    private KnowledgeProducerService knowledgeProducerService;

    @Resource
    private BizKnowledgeInfoService bizKnowledgeInfoService;

    @Resource
    private BizKnowledgeDocumentService bizKnowledgeDocumentService;

    @Resource
    private DemandKnowledgeService demandKnowledgeService;

    @Scheduled(cron = "0 0/1 * * * ?")
    public void knowledgeInfoStatusUpdateScheduler() throws Exception {
        KnowledgeInfosQueryCondition condition = new KnowledgeInfosQueryCondition();
        condition.setTrainStatus(KnowledgeConstant.TrainStatus.TRAINING);

        List<KnowledgeInfosQueryItem> items = bizKnowledgeInfoService.knowledgeInfos(condition, null);
        for (KnowledgeInfosQueryItem item : items) {
            KnowledgeTrainStatusMessage knowledgeTrainStatusMessage = new KnowledgeTrainStatusMessage();
            knowledgeTrainStatusMessage.setKnowledgeInfoId(item.getId());
            knowledgeProducerService.knowledgeInfoStatusCheck(knowledgeTrainStatusMessage);
        }
    }


    @Scheduled(cron = "0 0/1 * * * ?")
    public void knowledgeDocumentStatusUpdateScheduler() throws Exception {
        BizKnowledgeDocumentEntity knowledgeDocumentEntity = new BizKnowledgeDocumentEntity();
        knowledgeDocumentEntity.setTrainStatus(KnowledgeConstant.TrainStatus.TRAINING);
        knowledgeDocumentEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizKnowledgeDocumentEntity> entities = bizKnowledgeDocumentService.findByExample(knowledgeDocumentEntity, null);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        for (BizKnowledgeDocumentEntity entity : entities) {
            String trainKnowledgeStatus = demandKnowledgeService.trainKnowledgeStatus(entity.getKnowledgeId());
            if (KnowledgeTrainStatusConstant.fail.equals(trainKnowledgeStatus)) {
                KnowledgeTrainStatusMessage message = new KnowledgeTrainStatusMessage();
                message.setKdId(entity.getKdId());
                message.setKnowledgeId(entity.getKnowledgeId());
                message.setStatus(KnowledgeConstant.TrainStatus.FAIL);
                knowledgeProducerService.trainStatusUpdate(message);
                //记录失败原因
            } else if (KnowledgeTrainStatusConstant.success.equals(trainKnowledgeStatus)) {
                KnowledgeTrainStatusMessage message = new KnowledgeTrainStatusMessage();
                message.setKdId(entity.getKdId());
                message.setKnowledgeId(entity.getKnowledgeId());
                message.setStatus(KnowledgeConstant.TrainStatus.COMPLETE);
                knowledgeProducerService.trainStatusUpdate(message);
            }
        }

    }
}
