package cn.com.poc.support.sms;


import cn.com.poc.support.sms.constant.SmsConstant;
import cn.com.poc.support.sms.channel.baidu.BaiDuThirdPlatformService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;


/**
 * @author Focan.Zhong
 */
@Component
public class ThirdPlatformSmsServiceBuilder implements ApplicationContextAware {

    private ApplicationContext applicationContext;

    public ThirdPlatformSmsService getService(SmsConstant.Channel channel) throws Exception {

        if (SmsConstant.Channel.baidu.equals(channel)) {
            return applicationContext.getBean(BaiDuThirdPlatformService.class);
        }

        throw new I18nMessageException("exception/verification.code.channel.abnormality");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
