package cn.com.poc.thirdparty.resource.demand.ai.constants;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

public enum AIModelEnum {

    GPT_3(OPENAI.GPT_3, AIProviderEnum.OPENAI.name(), OPENAI.GPT_3),
    GPT_35(OPENAI.GPT_35, AIProviderEnum.OPENAI.name(), OPENAI.GPT_35),
    GPT_35_T(OPENAI.GPT_35_T, AIProviderEnum.OPENAI.name(), OPENAI.GPT_35_T),
    GPT_4(OPENAI.GPT_4, AIProviderEnum.OPENAI.name(), OPENAI.GPT_4),

    ERNIE_Bot(BAIDU.ERNIE_Bot, AIProviderEnum.BAIDU.name(), "ERNIE-Bot是百度自行研发的大语言模型，覆盖海量中文数据，具有更强的对话问答、内容创作生成等能力。"),
    ERNIE_Bot_4(BAIDU.ERNIE_Bot_4, AIProviderEnum.BAIDU.name(), "ERNIE-Bot是百度自行研发的大语言模型，覆盖海量中文数据，具有更强的对话问答、内容创作生成等能力。"),
    ERNIE_Bot_turbo(BAIDU.ERNIE_Bot_turbo, AIProviderEnum.BAIDU.name(), "ERNIE-Bot-turbo是百度自行研发的大语言模型，覆盖海量中文数据，具有更强的对话问答、内容创作生成等能力，响应速度更快。"),
    BLOOMZ_7B(BAIDU.BLOOMZ_7B, AIProviderEnum.BAIDU.name(), "BLOOMZ-7B是业内知名的大语言模型，由BigScience研发并开源，能够以46种语言和13种编程语言输出文本。"),
    ERNIE_35_8K_0205(BAIDU.ERNIE_35_8K_0205, AIProviderEnum.BAIDU.name(), "ERNIE 3.5是百度自研的旗舰级大规模⼤语⾔模型，覆盖海量中英文语料，具有强大的通用能力，可满足绝大部分对话问答、创作生成、插件应用场景要求；支持自动对接百度搜索插件，保障问答信息时效。ERNIE-3.5-8K-0205是模型的一个版本，支持5K tokens输入+2K tokens输出")
    ;

    String model;

    String provider;

    String intro;

    AIModelEnum(String model, String provider, String intro) {
        this.model = model;
        this.provider = provider;
        this.intro = intro;
    }

    public String getIntro() {
        return intro;
    }

    public String getModel() {
        return model;
    }

    public String getProvider() {
        return provider;
    }

    public static String matchProvider(String model) {
        Assert.notNull(model);
        String provider = new String();
        if (GPT_3.model.equals(model) || GPT_35.model.equals(model) || GPT_35_T.model.equals(model) || GPT_4.model.equals(model)) {
            provider = AIProviderEnum.OPENAI.name();
        } else if (BAIDU.BLOOMZ_7B.equals(model)
                || BAIDU.ERNIE_Bot.equals(model)
                || BAIDU.ERNIE_Bot_turbo.equals(model)
                || BAIDU.ERNIE_Bot_4.equals(model)
                || BAIDU.ERNIE_35_8K_0205.equals(model)
        ) {
            provider = AIProviderEnum.BAIDU.name();
        }
        return provider;
    }

    interface OPENAI {
        String GPT_3 = "gpt_3.0";
        String GPT_35 = "gpt_3.5";
        String GPT_35_T = "gpt-3.5-turbo";
        String GPT_4 = "gpt-4";
    }

    interface BAIDU {
        /**
         * ERNIE-Bot是百度自行研发的大语言模型，覆盖海量中文数据，具有更强的对话问答、内容创作生成等能力。
         */
        String ERNIE_Bot = "ERNIE_Bot";

        /**
         * ERNIE-Bot 4.0是百度自行研发的大语言模型，覆盖海量中文数据，具有更强的对话问答、内容创作生成等能力。本文介绍了千帆相关API及应用。
         */
        String ERNIE_Bot_4 = "ERNIE_Bot_4";

        /**
         * ERNIE-Bot-turbo是百度自行研发的大语言模型，覆盖海量中文数据，具有更强的对话问答、内容创作生成等能力，响应速度更快。
         */
        String ERNIE_Bot_turbo = "ERNIE_Bot_turbo";

        /**
         * BLOOMZ-7B是业内知名的大语言模型，由BigScience研发并开源，能够以46种语言和13种编程语言输出文本。
         */
        String BLOOMZ_7B = "BLOOMZ_7B";

        /**
         * ERNIE 3.5是百度自研的旗舰级大规模⼤语⾔模型，覆盖海量中英文语料，具有强大的通用能力，可满足绝大部分对话问答、创作生成、插件应用场景要求；
         * 支持自动对接百度搜索插件，保障问答信息时效。ERNIE-3.5-8K-0205是模型的一个版本，支持5K tokens输入+2K tokens输出
         */
        String ERNIE_35_8K_0205 = "ERNIE-3.5-8K-0205";
    }

    /**
     * 根据平台名查询平台下的所有大模型信息
     *
     * @param provider 平台名
     */
    public static List<AIModelEnum> getAiModelEnumByProvider(String provider) {

        if (StringUtils.isBlank(provider)) {
            return null;
        }
        List<AIModelEnum> aiModelEnumList = new ArrayList<>();
        for (AIModelEnum value : AIModelEnum.values()) {
            if (value.provider.equals(provider)) {
                aiModelEnumList.add(value);
            }
        }
        return aiModelEnumList;

    }

}
