package cn.com.poc.thirdparty.resource.demand.ai.function.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FunctionLLMConfig {

    private String type;

    private String description;

    private Function function;

    public String getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }

    public Function getFunction() {
        return function;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public static class FunctionLLMConfigBuilder {

        private String type = "function";

        private String description;

        private Function function = new Function();

        public FunctionLLMConfigBuilder description(String description) {
            this.description = description;
            this.function.setDescription(description);
            return this;
        }

        public FunctionLLMConfigBuilder name(String name) {
            this.function.setName(name);
            return this;
        }

        public FunctionLLMConfigBuilder parameters(Parameters parameters) {
            this.function.setParameters(parameters);
            return this;
        }

        public FunctionLLMConfig build() {
            FunctionLLMConfig config = new FunctionLLMConfig();
            config.setType(type);
            config.setDescription(description);
            config.setFunction(function);
            return config;
        }
    }

}
