package cn.com.poc.equity.aggregate;


import cn.com.poc.equity.constants.EquityEnum;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;

import static org.junit.Assert.assertNotNull;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class EquityServiceTest {

    @InjectMocks
    @Resource
    private EquityService equityService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void test_createEquityOrder() {
        Long memberId = 197L;
        EquityEnum.TYPE type = EquityEnum.TYPE.professional;
        EquityEnum.DOMAIN domain = EquityEnum.DOMAIN.equity;
        EquityEnum.VALIDITY_UNIT validityUnit = EquityEnum.VALIDITY_UNIT.year;
        String equityOrder = null;
        try {
            equityOrder = equityService.createEquityOrder(type, domain, validityUnit, memberId);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        assertNotNull(equityOrder);
        System.out.println("创建订单：" + equityOrder);
    }
}
