package cn.com.poc.common.utils;

import cn.com.poc.common.entity.oss.ImageUrl;
import cn.com.yict.framemax.core.config.Config;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.PutObjectRequest;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * oss工具类
 */
public class OssUtils {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    final static String RCS_UPLOAD_PATH = Config.get("uploadPath");

    @Autowired
    private FmxParamConfigService paramConfigService;

    /**
     * 执行下载和上传得到目标系统的url
     *
     * @param downloadUrl
     * @return
     */
    private String executeDownloadAndUploadAliyun(String downloadUrl) throws IOException {
        StringBuffer url = new StringBuffer();
        String uploadFolder = "mini-program-url/";
        byte[] content = getBytesFromUrl(downloadUrl);
        ImageUrl imageUrl = null;
        String fileType = "jpeg";
        //将文件上传到OSS
        //若catalog为其他则表示为普通图片上传
        imageUrl = uploadFileToOss(content, uploadFolder, fileType);

        if (imageUrl.getImageUrls().size() == 0) {
            throw new I18nMessageException("exception/upload.exception.please.check.the.file.before.uploading.again");
        }
        Optional.ofNullable(imageUrl).map(ImageUrl::getImageUrls).ifPresent(urls -> {
            url.append(urls.get(0));
            logger.info("小程序图片地址{}", urls.get(0));
        });


//        if (MessageStatus.SUCCESS.equals(result.getStatus())) {
//            ImageUrl imageUrl = JsonUtils.deSerialize(JsonUtils.serialize(result.getData()), ImageUrl.class);
//
//
//        } else {
//            throw new I18nMessageException("调用上传阿里云图片异常！");
//        }

        return url.toString();
    }


    /**
     * @param decodedByte
     * @param uploadFolder
     * @return oss的url
     * @throws IOException
     */
    public ImageUrl uploadFileToOss(byte[] decodedByte, String uploadFolder, String fileType) throws IOException {

        String appDir = "app/appId/";
        String rootPath = RCS_UPLOAD_PATH + "blo" + appDir;

        String endpoint = paramConfigService.getParam("oss.endPoint");
        String accessKeyId = paramConfigService.getParam("oss.accessKeyId");
        String accessKeySecret = paramConfigService.getParam("oss.accessKeySecret");
        String sourceBucketName = paramConfigService.getParam("oss.sourceBucketName");

        String isStoreInLocal = paramConfigService.getParam("oss.isStoreInLocal");
        String date = DateUtils.formatDate(new Date(), "yyyyMMdd");

        // 如果上传目录不以【/】结尾，加上
        if (uploadFolder.endsWith("/")) {
            uploadFolder = uploadFolder + date + "/";

        } else {
            uploadFolder = uploadFolder + "/" + date + "/";
        }
        String sourceKey = appDir + uploadFolder;  //sourceKey=oss.sourceKey + currentDate
        String filePath = rootPath + uploadFolder;
        String fileName = createFileName(fileType);
        ImageUrl imageUrl = null;
        List<String> list = new ArrayList<String>();

        // 处理数据
        for (int i = 0; i < decodedByte.length; ++i) {
            if (decodedByte[i] < 0) {
                decodedByte[i] += 256;
            }
        }

        try (InputStream inputStream = new ByteArrayInputStream(decodedByte, 0, decodedByte.length)) {
            /*
             * Constructs a client instance with your account for accessing OSS
             */
            OSSClient client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
            /*
             * Upload an object to your source bucket
             * 将本地文件上传至oss
             */
            client.putObject(new PutObjectRequest(sourceBucketName, sourceKey + fileName, inputStream));

        } catch (OSSException oe) {
            logger.info("Caught an OSSException, which means your request made it to OSS, "
                    + "but was rejected with an error response for some reason.");
            logger.info("Error Message: " + oe.getErrorCode());
            logger.info("Error Code:       " + oe.getErrorCode());
            logger.info("Request ID:      " + oe.getRequestId());
            logger.info("Host ID:           " + oe.getHostId());
        } catch (ClientException ce) {
            logger.info("Caught an ClientException, which means the client encountered "
                    + "a serious internal problem while trying to communicate with OSS, "
                    + "such as not being able to access the network.");
            logger.info("Error Message: " + ce.getMessage());
        }
//        //若应用oss配置了在本地留存则保存
//        if ("true".equals(isStoreInLocal)) {
//            createPath(filePath);
//
//            storeFileToLocal(decodedByte, filePath + fileName);//rootpath + catalog + fileName
//
//            logger.info("文件保存到本地！");
//        }

        //返回文件的oss地址
        StringBuilder osspath = new StringBuilder();
        osspath.append("https://").
                append(sourceBucketName).
                append(".").
                append(endpoint.replaceAll("http://", "")).
                append("/").
                append(sourceKey).append(fileName);
        list.add(osspath.toString());
        imageUrl = new ImageUrl();
        imageUrl.setImageUrls(list);

        return imageUrl;
    }

    //返回即将创建的文件名
    private String createFileName(String fileType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.currentTimeMillis()).
                append(".").
                append(fileType);
        return stringBuilder.toString();
    }

    //处理文件的byte数据
    public byte[] getBytesFromUrl(String url1) {
        logger.info("url is :" + url1);
        byte[] content = null;
        try {
            URL url = new URL(url1);
            logger.info("url protocal:" + url.getProtocol());

            HttpURLConnection httpUrl = (HttpURLConnection) url.openConnection();
            httpUrl.setRequestMethod("GET");
            httpUrl.usingProxy();
            httpUrl.connect();

            try (BufferedInputStream inputStream = new BufferedInputStream(httpUrl.getInputStream())) {
                byte[] bytes = new byte[1024];
                int len = 0;
                int index = 0;
                byte[] ob = null;
                byte[] nb = null;
                while ((len = inputStream.read(bytes)) > 0) {

                    if (nb == null) {
                        nb = new byte[len];
                        for (int addition = 0; addition < len; addition++) {
                            nb[addition] = bytes[addition];
                        }
                    } else {
                        nb = new byte[ob.length + len];
                        for (index = 0; index < ob.length; index++) {
                            nb[index] = ob[index];
                        }
                        for (int addition = 0; addition < len; addition++) {
                            nb[addition + index] = bytes[addition];
                        }
                    }
                    logger.info("readed length :" + len);
                    logger.info("curTotal length :" + nb.length);
                    ob = nb;
                }
                content = nb;
            } finally {
                httpUrl.disconnect();
            }

        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (content == null) {
            throw new I18nMessageException("exception/cannot.read.data.from.this.url");
        }
        logger.info("size:" + content.length);

        return content;
    }

}
