package cn.com.poc.equity.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.equity.aggregate.EquityService;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.dto.EquityOrderCreateDto;
import cn.com.poc.equity.rest.EquityOrderRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.hutool.core.util.ObjectUtil;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class EquityOrderRestImpl implements EquityOrderRest {


    @Resource
    private EquityService equityService;

    @Override
    public String createOrder(EquityOrderCreateDto createDto) throws Exception {
        Assert.notNull(createDto);
        Assert.notNull(createDto.getType());
        Assert.isTrue(EquityEnum.TYPE.isMatch(createDto.getType()));
        Assert.notNull(createDto.getDomain());
        Assert.isTrue(EquityEnum.DOMAIN.isMatch(createDto.getDomain()));
        Assert.notNull(createDto.getValidityUnit());
        Assert.isTrue(EquityEnum.VALIDITY_UNIT.isMatch(createDto.getValidityUnit()));

        // 获取当前登录用户
        UserBaseEntity currentUser = BlContext.getCurrentUserNotException();
        if (ObjectUtil.isEmpty(currentUser)) {
            throw new I18nMessageException("exception/user.not.login");
        }

        return equityService.createEquityOrder(
                EquityEnum.TYPE.valueOf(createDto.getType()),
                EquityEnum.DOMAIN.valueOf(createDto.getDomain()),
                EquityEnum.VALIDITY_UNIT.valueOf(createDto.getValidityUnit()),
                currentUser.getUserId());
    }
}
