package cn.com.poc.equity.rest.impl;

import cn.com.poc.equity.aggregate.EquityService;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.domain.AgentEquity;
import cn.com.poc.equity.dto.EquityPackagesDto;
import cn.com.poc.equity.rest.EquityRest;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class EquityRestImpl implements EquityRest {


    @Resource
    private EquityService equityService;

    @Override
    public EquityPackagesDto getPackageList() {
        List<AgentEquity> professinalList = equityService.getEquityList(EquityEnum.TYPE.professional);
        List<AgentEquity> ultimateList = equityService.getEquityList(EquityEnum.TYPE.ultimate);
        EquityPackagesDto equityPackagesDto = new EquityPackagesDto();
        equityPackagesDto.setProfessional(professinalList);
        equityPackagesDto.setUltimate(ultimateList);
        return equityPackagesDto;
    }


    @Override
    public Object getPointPackageList() {
        return equityService.getPointList();
    }
}
