package cn.com.poc.thirdparty.resource.demand.pay.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for dgtools_pay_order
 * 付款订单
 */
@Entity
@Table(name = "dgtools_pay_order")
@DynamicInsert
@DynamicUpdate
public class DgtoolsPayOrderModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** pay_order_id
    *预付款id
    */ 
    private Integer payOrderId;
    
    @Column(name = "pay_order_id",length = 10)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public Integer getPayOrderId(){
        return this.payOrderId;
    }
    
    public void setPayOrderId(Integer payOrderId){
        this.payOrderId = payOrderId;
        super.addValidField("payOrderId");
    }
    
  
    /** pay_order_sn
    *预付款号
    */ 
    private String payOrderSn;
    
    @Column(name = "pay_order_sn",length = 50)
    public String getPayOrderSn(){
        return this.payOrderSn;
    }
    
    public void setPayOrderSn(String payOrderSn){
        this.payOrderSn = payOrderSn;
        super.addValidField("payOrderSn");
    }
    
  
    /** pay_order_type
    *预付款类型(MarketingGamePay:游戏支付)
    */ 
    private String payOrderType;
    
    @Column(name = "pay_order_type",length = 255)
    public String getPayOrderType(){
        return this.payOrderType;
    }
    
    public void setPayOrderType(String payOrderType){
        this.payOrderType = payOrderType;
        super.addValidField("payOrderType");
    }

    /**
     * sharer_id
     * 分享者id
     */
    private Integer sharerId;

    @Column(name = "sharer_id", length = 10)
    public Integer getSharerId() {
        return sharerId;
    }

    public void setSharerId(Integer sharerId) {
        this.sharerId = sharerId;
        super.addValidField("sharerId");
    }

    /** total_amount
    *订单金额(分)
    */ 
    private Integer totalAmount;
    
    @Column(name = "total_amount",length = 10)
    public Integer getTotalAmount(){
        return this.totalAmount;
    }
    
    public void setTotalAmount(Integer totalAmount){
        this.totalAmount = totalAmount;
        super.addValidField("totalAmount");
    }
    
  
    /** paid_amount
    *已付金额(分)
    */ 
    private Integer paidAmount;
    
    @Column(name = "paid_amount",length = 10)
    public Integer getPaidAmount(){
        return this.paidAmount;
    }
    
    public void setPaidAmount(Integer paidAmount){
        this.paidAmount = paidAmount;
        super.addValidField("paidAmount");
    }
    
  
    /** need_pay_amount
    *订单待付金额(分)
    */ 
    private Integer needPayAmount;
    
    @Column(name = "need_pay_amount",length = 10)
    public Integer getNeedPayAmount(){
        return this.needPayAmount;
    }
    
    public void setNeedPayAmount(Integer needPayAmount){
        this.needPayAmount = needPayAmount;
        super.addValidField("needPayAmount");
    }
    
  
    /** member_id
    *下单人id
    */ 
    private Integer memberId;
    
    @Column(name = "member_id",length = 10)
    public Integer getMemberId(){
        return this.memberId;
    }
    
    public void setMemberId(Integer memberId){
        this.memberId = memberId;
        super.addValidField("memberId");
    }
    
  
    /** marketing_game_flow_no
    *游戏号
    */ 
    private String marketingGameFlowNo;
    
    @Column(name = "marketing_game_flow_no",length = 11)
    public String getMarketingGameFlowNo(){
        return this.marketingGameFlowNo;
    }
    
    public void setMarketingGameFlowNo(String marketingGameFlowNo){
        this.marketingGameFlowNo = marketingGameFlowNo;
        super.addValidField("marketingGameFlowNo");
    }
    
  
    /** currency
    *币种
    */ 
    private String currency;
    
    @Column(name = "currency",length = 10)
    public String getCurrency(){
        return this.currency;
    }
    
    public void setCurrency(String currency){
        this.currency = currency;
        super.addValidField("currency");
    }
    
  
    /** retain_information
    *留资信息
    */ 
    private String retainInformation;
    
    @Column(name = "retain_information",length = 1073741824)
    public String getRetainInformation(){
        return this.retainInformation;
    }
    
    public void setRetainInformation(String retainInformation){
        this.retainInformation = retainInformation;
        super.addValidField("retainInformation");
    }
    
  
    /** description
    *描述
    */ 
    private String description;
    
    @Column(name = "description",length = 500)
    public String getDescription(){
        return this.description;
    }
    
    public void setDescription(String description){
        this.description = description;
        super.addValidField("description");
    }

    /** order_status
        *支付状态:
        NoPayment-待支付;
        Refunding-退款中;
        Paid-已付款;
        Cancel-已取消;
    */
    private String orderStatus;

    @Column(name = "order_status",length = 255)
    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
        super.addValidField("orderStatus");
    }


    /** pay_status
        *支付状态:
        NoPayment-待支付;
        Refunding-退款中;
        Paid-已付款;
        Cancel-已取消;
    */
    private String payStatus;

    @Column(name = "pay_status",length = 255)
    public String getPayStatus(){
        return this.payStatus;
    }

    public void setPayStatus(String payStatus){
        this.payStatus = payStatus;
        super.addValidField("payStatus");
    }
    
  
    /** pay_time
    *付款时间
    */ 
    private java.util.Date payTime;
    
    @Column(name = "pay_time",length = 19)
    public java.util.Date getPayTime(){
        return this.payTime;
    }
    
    public void setPayTime(java.util.Date payTime){
        this.payTime = payTime;
        super.addValidField("payTime");
    }
    
  
    /** cancel_time
    *订单取消时间
    */ 
    private java.util.Date cancelTime;
    
    @Column(name = "cancel_time",length = 19)
    public java.util.Date getCancelTime(){
        return this.cancelTime;
    }
    
    public void setCancelTime(java.util.Date cancelTime){
        this.cancelTime = cancelTime;
        super.addValidField("cancelTime");
    }
    
  
    /** corp_info_id
    *企业号
    */ 
    private Integer corpInfoId;
    
    @Column(name = "corp_info_id",length = 10)
    public Integer getCorpInfoId(){
        return this.corpInfoId;
    }
    
    public void setCorpInfoId(Integer corpInfoId){
        this.corpInfoId = corpInfoId;
        super.addValidField("corpInfoId");
    }
    
  
    /** merchant_id
    *商家号
    */ 
    private Integer merchantId;
    
    @Column(name = "merchant_id",length = 10)
    public Integer getMerchantId(){
        return this.merchantId;
    }
    
    public void setMerchantId(Integer merchantId){
        this.merchantId = merchantId;
        super.addValidField("merchantId");
    }
    
  
    /** is_deleted
    *是否删除 Y 是  N 否
    */ 
    private String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR",length = 11)
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER",length = 11)
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}