package cn.com.poc.user.builder;

import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.query.CheckMemberInfoQueryCondition;
import cn.com.poc.user.query.CheckMemberInfoQueryItem;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author：Roger Wu
 * @name：SmsLoginChannel
 * @Date：2024-07-23 18:01
 */

@Service
public class SmsLoginChannel implements LoginChannelService {

    @Resource
    private BizMemberInfoService bizMemberInfoService;
    @Resource
    private JudgeCodeService judgeCodeService;
    @Resource
    private FmxParamConfigService fmxParamConfigService;


    @Override
    public MemberInfoEntity doLogin(MemberLoginRequestDto memberLoginRequest) throws Exception {
        Assert.notBlank(memberLoginRequest.getAccount());
        Assert.notBlank(memberLoginRequest.getAuthCode());

        //验证验证码
        if (!judgeCodeService.judgeCode(memberLoginRequest.getAccount(), memberLoginRequest.getAuthCode())) {
            throw new I18nMessageException("exception/verification.code.is.incorrect.please.re-enter");
        }

        MemberInfoEntity result = bizMemberInfoService.getMemberEntityByAccount(memberLoginRequest.getAccount());
        if (result == null) { //用户没有注册过 需要注册
            CheckMemberInfoQueryCondition condition = new CheckMemberInfoQueryCondition();
            condition.setMobilePhone(memberLoginRequest.getAccount());
            List<CheckMemberInfoQueryItem> checkMemberInfoQueryItems = bizMemberInfoService.checkMemberInfoIsExist(condition);
            if (CollectionUtils.isEmpty(checkMemberInfoQueryItems)) {
                result = registerByMobilePhone(memberLoginRequest);
            } else { //用户已经注册过 直接登录
                CheckMemberInfoQueryItem checkMemberInfoQueryItem = checkMemberInfoQueryItems.get(0);
                Integer memberId = checkMemberInfoQueryItem.getMemberId();
                result = bizMemberInfoService.getById(memberId);
            }
        }

        return result;
    }

    private MemberInfoEntity registerByMobilePhone(MemberLoginRequestDto memberLoginRequest) {
        MemberInfoEntity result;
        MemberInfoEntity memberInfoEntity = new MemberInfoEntity();
        memberInfoEntity.setAccount(memberLoginRequest.getAccount());
        memberInfoEntity.setNickName(memberLoginRequest.getAccount());
        String param = fmxParamConfigService.getParam("member.default.avatar");
        if (StringUtils.isNoneBlank(param)) {
            memberInfoEntity.setAvatarUrl(param);
        }
        memberInfoEntity.setMobilePhone(memberLoginRequest.getAccount());
        result = bizMemberInfoService.createMemberInfo(memberInfoEntity);
        return result;
    }


}
