package cn.com.poc.agent_application.convert;

import cn.com.poc.agent_application.domain.*;
import cn.com.poc.agent_application.dto.BizAgentApplicationPublishDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.agent_application.entity.VoiceConfig;
import cn.com.poc.agent_application.model.BizAgentApplicationPublishModel;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.JsonUtils;
import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.core.utils.JsonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class BizAgentApplicationPublishConvert {

    public static BizAgentApplicationPublishEntity modelToEntity(BizAgentApplicationPublishModel model) {
        BizAgentApplicationPublishEntity entity = new BizAgentApplicationPublishEntity();
        entity.setId(model.getId());
        entity.setMemberId(model.getMemberId());
        entity.setAgentId(model.getAgentId());
        entity.setAgentAvatar(model.getAgentAvatar());
        entity.setAgentTitle(model.getAgentTitle());
        entity.setAgentDesc(model.getAgentDesc());
        entity.setAgentSystem(model.getAgentSystem());
        entity.setPreamble(model.getPreamble());
        entity.setIsLongMemory(model.getIsLongMemory());
        entity.setPublishTime(model.getModifiedTime());
        entity.setIsDocumentParsing(model.getIsDocumentParsing());
        if (StringUtils.isNotBlank(model.getVariableStructure())) {
            entity.setVariableStructure(JsonUtils.deSerialize(model.getVariableStructure(), new TypeReference<List<Variable>>() {
            }.getType()));
        }

        if (StringUtils.isNotBlank(model.getFeaturedQuestions())) {
            entity.setFeaturedQuestions(JsonUtils.deSerialize(model.getFeaturedQuestions(), String[].class));
        }
        entity.setCommunicationTurn(model.getCommunicationTurn());
        entity.setContinuousQuestionStatus(model.getContinuousQuestionStatus());
        entity.setContinuousQuestionSystem(model.getContinuousQuestionSystem());
        entity.setContinuousQuestionTurn(model.getContinuousQuestionTurn());
        if (StringUtils.isNotBlank(model.getKnowledgeIds())) {
            entity.setKnowledgeIds(JsonUtils.deSerialize(model.getKnowledgeIds(), Integer[].class));
        }
        entity.setLargeModel(model.getLargeModel());
        entity.setTopP(model.getTopP());
        entity.setTemperature(model.getTemperature());
        if (StringUtils.isNotBlank(model.getUnitIds())) {
            entity.setUnitIds(JsonUtils.deSerialize(model.getUnitIds(), String[].class));
        }
        if (StringUtils.isNotBlank(model.getVoiceConfig())) {
            VoiceConfig voiceConfig = JsonUtils.deSerialize(model.getVoiceConfig(), VoiceConfig.class);
            entity.setVoiceConfig(voiceConfig);
        }
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        return entity;
    }

    public static BizAgentApplicationPublishModel entityToModel(BizAgentApplicationPublishEntity entity) {
        BizAgentApplicationPublishModel model = new BizAgentApplicationPublishModel();
        model.setId(entity.getId());
        model.setMemberId(entity.getMemberId());
        model.setAgentId(entity.getAgentId());
        model.setAgentAvatar(entity.getAgentAvatar());
        model.setAgentTitle(entity.getAgentTitle());
        model.setAgentDesc(entity.getAgentDesc());
        model.setAgentSystem(entity.getAgentSystem());
        model.setPreamble(entity.getPreamble());
        model.setIsLongMemory(entity.getIsLongMemory());
        model.setIsDocumentParsing(entity.getIsDocumentParsing());
        if (CollectionUtils.isNotEmpty(entity.getVariableStructure())) {
            model.setVariableStructure(JsonUtils.serialize(entity.getVariableStructure()));
        }
        if (ArrayUtils.isNotEmpty(entity.getFeaturedQuestions())) {
            model.setFeaturedQuestions(JsonUtils.serialize(entity.getFeaturedQuestions()));
        }
        model.setCommunicationTurn(entity.getCommunicationTurn());
        model.setContinuousQuestionStatus(entity.getContinuousQuestionStatus());
        model.setContinuousQuestionSystem(entity.getContinuousQuestionSystem());
        model.setContinuousQuestionTurn(entity.getContinuousQuestionTurn());
        if (ArrayUtils.isNotEmpty(entity.getKnowledgeIds())) {
            model.setKnowledgeIds(JsonUtils.serialize(entity.getKnowledgeIds()));
        }
        model.setLargeModel(entity.getLargeModel());
        model.setTopP(entity.getTopP());
        model.setTemperature(entity.getTemperature());
        if (ArrayUtils.isNotEmpty(entity.getUnitIds())) {
            model.setUnitIds(JsonUtil.toJson(entity.getUnitIds()));
        }
        if (ObjectUtil.isNotEmpty(entity.getVoiceConfig())) {
            model.setVoiceConfig(JsonUtils.serialize(entity.getVoiceConfig()));
        }

        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        return model;
    }

    public static BizAgentApplicationPublishDto entityToDto(BizAgentApplicationPublishEntity entity) {
        BizAgentApplicationPublishDto dto = new BizAgentApplicationPublishDto();
        AgentApplicationBaseInfo baseInfo = new AgentApplicationBaseInfo();
        baseInfo.setMemberId(entity.getMemberId());
        baseInfo.setAgentId(entity.getAgentId());
        baseInfo.setAgentTitle(entity.getAgentTitle());
        baseInfo.setAgentAvatar(entity.getAgentAvatar());
        baseInfo.setAgentDesc(entity.getAgentDesc());
        baseInfo.setAgentSystem(entity.getAgentSystem());
        baseInfo.setAgentPublishStatus(entity.getAgentPublishStatus());
        baseInfo.setPublishTime(entity.getPublishTime());

        AgentApplicationCommConfig commConfig = new AgentApplicationCommConfig();
        commConfig.setPreamble(entity.getPreamble());
        commConfig.setFeaturedQuestions(entity.getFeaturedQuestions());
        commConfig.setContinuousQuestionStatus(entity.getContinuousQuestionStatus());
        commConfig.setContinuousQuestionSystem(entity.getContinuousQuestionSystem());
        commConfig.setContinuousQuestionTurn(entity.getContinuousQuestionTurn());
        commConfig.setVariableStructure(entity.getVariableStructure());
        commConfig.setIsLongMemory(entity.getIsLongMemory());

        AgentApplicationKnowledgeConfig knowledgeConfig = new AgentApplicationKnowledgeConfig();
        knowledgeConfig.setKnowledgeIds(entity.getKnowledgeIds());
        knowledgeConfig.setIsDocumentParsing(entity.getIsDocumentParsing());

        AgentApplicationCommModelConfig commModelConfig = new AgentApplicationCommModelConfig();
        commModelConfig.setLargeModel(entity.getLargeModel());
        commModelConfig.setTopP(entity.getTopP());
        commModelConfig.setTemperature(entity.getTemperature());
        commModelConfig.setCommunicationTurn(entity.getCommunicationTurn());

        AgentApplicationVoiceConfig voiceConfig = new AgentApplicationVoiceConfig();
        if (ObjectUtil.isNotEmpty(entity.getVoiceConfig())) {
            voiceConfig.setDefaultOpen(entity.getVoiceConfig().getDefaultOpen());
            voiceConfig.setTimbreId(entity.getVoiceConfig().getTimbreId());
        } else {
            voiceConfig.setDefaultOpen(CommonConstant.YOrN.N);
            voiceConfig.setTimbreId(StringUtils.EMPTY);
        }


        dto.setBaseInfo(baseInfo);
        dto.setCommConfig(commConfig);
        dto.setKnowledgeConfig(knowledgeConfig);
        dto.setCommModelConfig(commModelConfig);
        dto.setVoiceConfig(voiceConfig);
        dto.setUnitIds(entity.getUnitIds());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifiedTime(entity.getModifiedTime());
        return dto;
    }

    public static BizAgentApplicationPublishEntity dtoToEntity(BizAgentApplicationPublishDto dto) {
        BizAgentApplicationPublishEntity entity = new BizAgentApplicationPublishEntity();
        if (ObjectUtil.isNotEmpty(dto.getBaseInfo())) {
            entity.setAgentId(dto.getBaseInfo().getAgentId());
            entity.setMemberId(dto.getBaseInfo().getMemberId());
            entity.setAgentAvatar(dto.getBaseInfo().getAgentAvatar());
            entity.setMemberId(dto.getBaseInfo().getMemberId());
            entity.setAgentTitle(dto.getBaseInfo().getAgentTitle());
            entity.setAgentDesc(dto.getBaseInfo().getAgentDesc());
            entity.setAgentSystem(dto.getBaseInfo().getAgentSystem());
            entity.setAgentPublishStatus(dto.getBaseInfo().getAgentPublishStatus());
            entity.setPublishTime(dto.getBaseInfo().getPublishTime());
        }

        if (ObjectUtil.isNotEmpty(dto.getCommConfig())) {
            entity.setPreamble(dto.getCommConfig().getPreamble());
            entity.setFeaturedQuestions(dto.getCommConfig().getFeaturedQuestions());
            entity.setCommunicationTurn(dto.getCommConfig().getContinuousQuestionTurn());
            entity.setContinuousQuestionStatus(dto.getCommConfig().getContinuousQuestionStatus());
            entity.setContinuousQuestionSystem(dto.getCommConfig().getContinuousQuestionSystem());
            entity.setContinuousQuestionTurn(dto.getCommConfig().getContinuousQuestionTurn());
            entity.setIsLongMemory(dto.getCommConfig().getIsLongMemory());
            if (CollectionUtils.isNotEmpty(dto.getCommConfig().getVariableStructure())) {
                entity.setVariableStructure(dto.getCommConfig().getVariableStructure());
            }
        }

        if (ObjectUtil.isNotEmpty(dto.getKnowledgeConfig())) {
            entity.setKnowledgeIds(dto.getKnowledgeConfig().getKnowledgeIds());
            entity.setIsDocumentParsing(dto.getKnowledgeConfig().getIsDocumentParsing());
        }

        if (ObjectUtil.isNotEmpty(dto.getCommModelConfig())) {
            entity.setLargeModel(dto.getCommModelConfig().getLargeModel());
            entity.setTopP(dto.getCommModelConfig().getTopP());
            entity.setTemperature(dto.getCommModelConfig().getTemperature());
        }

        VoiceConfig voiceConfig = new VoiceConfig();
        if (ObjectUtil.isNotEmpty(dto.getVoiceConfig())) {
            voiceConfig.setDefaultOpen(dto.getVoiceConfig().getDefaultOpen());
            voiceConfig.setTimbreId(dto.getVoiceConfig().getTimbreId());
        } else {
            voiceConfig.setDefaultOpen(CommonConstant.YOrN.N);
            voiceConfig.setTimbreId(StringUtils.EMPTY);
        }
        entity.setUnitIds(dto.getUnitIds());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifiedTime(dto.getModifiedTime());
        return entity;
    }
}