package cn.com.poc.data_analyze.constants;

/**
 * 数据来源渠道枚举
 *
 * @author alex.yao
 * @date 2024/12/10
 */
public enum DataAnalyzeChannelEnum {

    /**
     * 预览调试
     */
    PREVIEW("preview"),

    /**
     * 多模型调试
     */
    MULTI_PREVIEW("multi_preview"),

    /**
     * 首页
     */
    INDEX("index"),

    /**
     * 应用广场
     */
    MALL("mall"),

    /**
     * 链接分享
     */
    LINK_SHARE("link_share"),

    /**
     * API调用
     */
    API("api"),
    ;
    private String channel;

    public String getChannel() {
        return channel;
    }

    DataAnalyzeChannelEnum(String channel) {
        this.channel = channel;
    }

}
