package cn.com.poc.equity.constants;

/**
 * 会员权益枚举
 *
 * @author alex.yao
 */
public class EquityEnum {


    /**
     * 类型 normal-普通 professional-专业版 ， ultimate-旗舰版
     */
    public enum TYPE {
        normal, professional, ultimate;

        public static boolean isMatch(String type) {
            TYPE[] values = values();
            for (TYPE value : values) {
                if (value.name().equals(type)) {
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * 资源包领域 point-积分包 equity-权益包
     */
    public enum DOMAIN {
        point,
        equity;

        public static boolean isMatch(String domain) {
            DOMAIN[] values = values();
            for (DOMAIN value : values) {
                if (value.name().equals(domain)) {
                    return true;
                }
            }
            return false;
        }
    }

    /**
     * 有效期单位 month-月 year-年 indefinite-永久有效
     */
    public enum VALIDITY_UNIT {
        month, year, indefinite;

        public static boolean isMatch(String validityUnit) {
            VALIDITY_UNIT[] values = values();
            for (VALIDITY_UNIT value : values) {
                if (value.name().equals(validityUnit)) {
                    return true;
                }
            }
            return false;
        }
    }
}