package cn.com.poc.equity.model;

import java.io.Serializable;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_member_equity_pay_order_log
 * 会员权益订单表
 */
@Entity
@Table(name = "biz_member_equity_pay_order_log")
@DynamicInsert
@DynamicUpdate
public class BizMemberEquityPayOrderLogModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     */
    private java.lang.Long id;

    @Column(name = "id", length = 19)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Long getId() {
        return this.id;
    }

    public void setId(java.lang.Long id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * member_id
     * 用户id
     */
    private java.lang.Long memberId;

    @Column(name = "member_id", length = 19)
    public java.lang.Long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(java.lang.Long memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * pay_order_sn
     * 订单号
     */
    private java.lang.String payOrderSn;

    @Column(name = "pay_order_sn", length = 50)
    public java.lang.String getPayOrderSn() {
        return this.payOrderSn;
    }

    public void setPayOrderSn(java.lang.String payOrderSn) {
        this.payOrderSn = payOrderSn;
        super.addValidField("payOrderSn");
    }


    /**
     * pay_amount
     * 支付金额 - 分
     */
    private java.lang.Integer payAmount;

    @Column(name = "pay_amount", length = 10)
    public java.lang.Integer getPayAmount() {
        return this.payAmount;
    }

    public void setPayAmount(java.lang.Integer payAmount) {
        this.payAmount = payAmount;
        super.addValidField("payAmount");
    }


    /**
     * currency
     * 货币
     */
    private java.lang.String currency;

    @Column(name = "currency", length = 10)
    public java.lang.String getCurrency() {
        return this.currency;
    }

    public void setCurrency(java.lang.String currency) {
        this.currency = currency;
        super.addValidField("currency");
    }


    /**
     * type
     * 类型 normal-普通 professional-专业版 ， ultimate-旗舰版
     */
    private java.lang.String type;

    @Column(name = "type", length = 100)
    public java.lang.String getType() {
        return this.type;
    }

    public void setType(java.lang.String type) {
        this.type = type;
        super.addValidField("type");
    }


    /**
     * domain
     * 资源包领域 point-积分包 equity-权益包
     */
    private java.lang.String domain;

    @Column(name = "domain", length = 100)
    public java.lang.String getDomain() {
        return this.domain;
    }

    public void setDomain(java.lang.String domain) {
        this.domain = domain;
        super.addValidField("domain");
    }

    /**
     * total_points
     * 获得积分数
     */
    private java.lang.Long totalPoints;

    @Column(name = "total_points", length = 10)
    public java.lang.Long getTotalPoints() {
        return this.totalPoints;
    }

    public void setTotalPoints(java.lang.Long totalPoints) {
        this.totalPoints = totalPoints;
        super.addValidField("totalPoints");
    }

    /**
     * expired_num
     * 过期数
     */
    private java.lang.Integer expiredNum;

    @Column(name = "expired_num", length = 10)
    public java.lang.Integer getExpiredNum() {
        return this.expiredNum;
    }

    public void setExpiredNum(java.lang.Integer expiredNum) {
        this.expiredNum = expiredNum;
        super.addValidField("expiredNum");
    }


    /**
     * expired_type
     * 套餐过期类型   day-天 month-月 year-年 indefinite-无限期
     */
    private java.lang.String expiredType;

    @Column(name = "expired_type", length = 100)
    public java.lang.String getExpiredType() {
        return this.expiredType;
    }

    public void setExpiredType(java.lang.String expiredType) {
        this.expiredType = expiredType;
        super.addValidField("expiredType");
    }


    /**
     * pay_channel
     * 支付渠道: wx-微信 ali-支付宝
     */
    private java.lang.String payChannel;

    @Column(name = "pay_channel", length = 10)
    public java.lang.String getPayChannel() {
        return this.payChannel;
    }

    public void setPayChannel(java.lang.String payChannel) {
        this.payChannel = payChannel;
        super.addValidField("payChannel");
    }


    /**
     * pay_time
     * 付款时间
     */
    private java.util.Date payTime;

    @Column(name = "pay_time", length = 19)
    public java.util.Date getPayTime() {
        return this.payTime;
    }

    public void setPayTime(java.util.Date payTime) {
        this.payTime = payTime;
        super.addValidField("payTime");
    }


    /**
     * is_deleted
     * 是否删除 Y 是  N 否
     */
    private java.lang.String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public java.lang.String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(java.lang.String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private java.lang.String creator;

    @Column(name = "CREATOR", length = 50)
    public java.lang.String getCreator() {
        return this.creator;
    }

    public void setCreator(java.lang.String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private java.lang.String modifier;

    @Column(name = "MODIFIER", length = 50)
    public java.lang.String getModifier() {
        return this.modifier;
    }

    public void setModifier(java.lang.String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private java.lang.Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public java.lang.Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(java.lang.Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}