package cn.com.poc.equity.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.equity.aggregate.EquityService;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.dto.CurrentUserPayOrderDto;
import cn.com.poc.equity.dto.EquityOrderCreateDto;
import cn.com.poc.equity.entity.CurrentUserPayOrderEntity;
import cn.com.poc.equity.rest.EquityOrderRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.hutool.core.util.ObjectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Component
public class EquityOrderRestImpl implements EquityOrderRest {


    @Resource
    private EquityService equityService;

    @Override
    public String createOrder(EquityOrderCreateDto createDto) throws Exception {
        Assert.notNull(createDto);
        Assert.notNull(createDto.getType());
        Assert.isTrue(EquityEnum.TYPE.isMatch(createDto.getType()));
        Assert.notNull(createDto.getDomain());
        Assert.isTrue(EquityEnum.DOMAIN.isMatch(createDto.getDomain()));
        Assert.notNull(createDto.getValidityUnit());
        Assert.isTrue(EquityEnum.VALIDITY_UNIT.isMatch(createDto.getValidityUnit()));

        // 获取当前登录用户
        UserBaseEntity currentUser = BlContext.getCurrentUserNotException();
        if (ObjectUtil.isEmpty(currentUser)) {
            throw new I18nMessageException("exception/user.not.login");
        }

        return equityService.createEquityOrder(
                EquityEnum.TYPE.valueOf(createDto.getType()),
                EquityEnum.DOMAIN.valueOf(createDto.getDomain()),
                EquityEnum.VALIDITY_UNIT.valueOf(createDto.getValidityUnit()),
                currentUser.getUserId());
    }

    @Override
    public List<CurrentUserPayOrderDto> getCurrentUserPayOrderList(String domain, PagingInfo pagingInfo) {
        List<CurrentUserPayOrderDto> result = new ArrayList<>();
        UserBaseEntity currentUser = BlContext.getCurrentUser();
        List<CurrentUserPayOrderEntity> userPayOrderEntities = equityService.getUserOrderList(currentUser.getUserId(), EquityEnum.DOMAIN.valueOf(domain), pagingInfo);
        if (CollectionUtils.isNotEmpty(userPayOrderEntities)) {
            for (CurrentUserPayOrderEntity entity : userPayOrderEntities) {
                CurrentUserPayOrderDto dto = new CurrentUserPayOrderDto();
                dto.setType(entity.getType());
                dto.setDomain(entity.getDomain());
                dto.setExpiredNum(entity.getExpiredNum());
                dto.setExpiredType(entity.getExpiredType());
                dto.setPointNum(entity.getPointNum());
                dto.setRemainExpiredDay(entity.getRemainExpiredDay());
                dto.setAmount(entity.getAmount());
                dto.setPayTime(entity.getPayTime());
                dto.setPayChannel(entity.getPayChannel());
                dto.setPayOrderSn(entity.getPayOrderSn());
                result.add(dto);
            }
        }
        return result;
    }
}
