package cn.com.poc.expose.aggregate;

import cn.com.poc.data_analyze.domain.DataAnalyzeTimeRange;
import cn.com.poc.data_analyze.entity.*;

import java.util.List;

/**
 * @author alex.yao
 * @date 2024/12/11
 */
public interface AgentDataAnalyzeService {


    /**
     * 获取应用大体用量数据
     *
     * @param agentId 应用ID
     * @param channel 渠道
     * @return 应用大体用量数据
     */
    List<AgentDataAnalyzeGeneralEntity> getGeneralUsageData(String agentId, List<String> channel);

    /**
     * 当月渠道使用人数占比
     *
     * @param agentId 应用ID
     * @param channel 渠道
     * @@return 当月渠道使用人数占比
     */
    List<ChannelUsersCountEntity> getChannelUserCount(String agentId, List<String> channel);

    /**
     * 获取当月分渠道发送消息数占比
     *
     * @param agentId 应用ID
     * @param channel 渠道
     */
    List<ChannelUsageCountEntity> getSendMessageCount(String agentId, List<String> channel);

    /**
     * 获取当月分渠道积分消耗数占比
     *
     * @param agentId 应用ID
     * @param channel 渠道
     */
    List<ChannelPointCountEntity> getPointUsageCount(String agentId, List<String> channel);

    /**
     * 获取Agent应用数据趋势图
     *
     * @param agentId   应用ID
     * @param channel   渠道
     * @param timeRange 时间范围
     */
    List<AgentDataAnalyzeTrendEntity> getAgentDataTrend(String agentId, List<String> channel, DataAnalyzeTimeRange timeRange);

}
