package cn.com.poc.thirdparty.resource.demand.dgTools.request;


import cn.com.poc.thirdparty.resource.demand.dgTools.constants.Channel;
import cn.com.poc.thirdparty.resource.demand.dgTools.constants.Scence;
import cn.com.poc.thirdparty.resource.demand.dgTools.constants.TradeType;
import cn.com.poc.thirdparty.resource.demand.dgTools.result.H5TranssactionsResult;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Roger Wu
 */
public class H5PayRequest extends AbstractRequest<H5TranssactionsResult> implements Serializable {

    /**
     * 渠道
     */
    private Channel channel;

    /**
     * 场景
     */
    private Scence scence;

    /**
     * 交易类型
     */
    private TradeType tradeType;

    /**
     * 交易商户
     */
    private String acctId;

    /**
     * 交易平台
     */
    private String platformKey;

    /**
     * 用户标识
     */
    private String userIdentification;

    /**
     * 支付金额
     */
    private Integer payAmount;

    /**
     * 币种
     */
    private String currency;

    /**
     * 支付单号
     */
    private String bizUniqueNo;

    /**
     * 描述
     *
     * @return
     */
    private String description;

    /**
     * 回调地址
     */
    private String callBackUrl;

    /**
     * 过期时间
     */
    private Date expireTime;


    public Channel getChannel() {
        return channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Scence getScence() {
        return scence;
    }

    public void setScence(Scence scence) {
        this.scence = scence;
    }

    public TradeType getTradeType() {
        return tradeType;
    }

    public void setTradeType(TradeType tradeType) {
        this.tradeType = tradeType;
    }

    public String getAcctId() {
        return acctId;
    }

    public void setAcctId(String acctId) {
        this.acctId = acctId;
    }

    public String getPlatformKey() {
        return platformKey;
    }

    public void setPlatformKey(String platformKey) {
        this.platformKey = platformKey;
    }

    public String getUserIdentification() {
        return userIdentification;
    }

    public void setUserIdentification(String userIdentification) {
        this.userIdentification = userIdentification;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getBizUniqueNo() {
        return bizUniqueNo;
    }

    public void setBizUniqueNo(String bizUniqueNo) {
        this.bizUniqueNo = bizUniqueNo;
    }

    public Integer getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(Integer payAmount) {
        this.payAmount = payAmount;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCallBackUrl() {
        return callBackUrl;
    }

    public void setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }


    @Override
    public String getMethod() throws Exception {
        return null;
    }
}
