package cn.com.poc.thirdparty.resource.demand.dgTools.service.impl;

import cn.com.poc.common.constant.FmxParamConfigConstant;
import cn.com.poc.common.constant.MkpRedisKeyConstant;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.thirdparty.resource.demand.dgTools.DgtoolsAbstractHttpClient;
import cn.com.poc.thirdparty.resource.demand.ai.route.DgtoolsApiRoute;
import cn.com.poc.thirdparty.resource.demand.dgTools.request.ProjectTokenRequest;
import cn.com.poc.thirdparty.resource.demand.dgTools.result.ProjectTokenResult;
import cn.com.poc.thirdparty.resource.demand.dgTools.service.AuthorizationService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Roger Wu
 */
@Component
public class AuthorizationServiceImpl implements AuthorizationService {

    @Resource
    private DgtoolsAbstractHttpClient dgToolsAbstractHttpClient;

    @Resource
    private RedisService redisService;

    @Resource
    private FmxParamConfigService fmxParamConfigService;


    @Override
    public String applicationAuthorization() throws Exception {
        Map<String, String> paramConfigMap = getParamConfigMap();
        String projectKey = paramConfigMap.get(FmxParamConfigConstant.Dgtools.PROJECT_KEY);
        if (StringUtils.isEmpty(projectKey)) {
            throw new I18nMessageException("exception/key.for.the.marketing.platform.configuration.project.is.empty");
        }
        String projectSecret = paramConfigMap.get(FmxParamConfigConstant.Dgtools.PROJECT_SECRET);
        if (StringUtils.isEmpty(projectSecret)) {
            throw new I18nMessageException("exception/secret.for.the.marketing.platform.configuration.project.is.empty");
        }

        ProjectTokenRequest request = new ProjectTokenRequest();
        request.setProjectKey(projectKey);
        request.setProjectSecret(projectSecret);
        List<Header> headers = new ArrayList<>();
        headers.add(DgtoolsApiRoute.PAY_HEADER);
        ProjectTokenResult projectTokenResult = dgToolsAbstractHttpClient.doRequest(DgtoolsApiRoute.GET_APP_TOKEN, request, headers);
        return projectTokenResult.getAppToken();
    }

    /**
     * 获取中台的apptoken
     *
     * @return
     * @throws Exception
     */
    @Override
    public String getApplicationToken() throws Exception {
        String dgtoolsAppToken = MkpRedisKeyConstant.DGTOOLS_APP_TOKEN;
        String appToken = (String) redisService.get(dgtoolsAppToken);
        if (StringUtils.isNotEmpty(appToken)) {
            return appToken;
        } else {
            appToken = applicationAuthorization();
            if (StringUtils.isEmpty(appToken)) {
                throw new I18nMessageException("exception/failed.to.obtain.xinghai.apptoken");
            }
            redisService.set(dgtoolsAppToken, appToken, 60 * 60 * 24 * 7 - 1000);
            return appToken;
        }
    }

    /**
     * 根据前缀获取配置表的数据
     *
     * @return
     */
    private Map<String, String> getParamConfigMap() {
        //获取统一id
        return fmxParamConfigService.getStartsWith(FmxParamConfigConstant.Prefix.DG_TOOLS);
    }

}
