package cn.com.poc.thirdparty.resource.demand.pay.processor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author alex.yao
 * @date 2024/12/9
 */
@Component
public class IPayPostProcessor {

    @Autowired(required = false)
    private List<AbstractPayPostProcessor> payPostProcessorList;

    public void postProcess(String payOrderType, String orderSn) {
        for (AbstractPayPostProcessor payPostProcessor : payPostProcessorList) {
            if (payPostProcessor.support(payOrderType)) {
                payPostProcessor.postProcessSuccess(orderSn);
            }
        }
    }

}
