package cn.com.poc.agent_application.aggregate.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationMallService;
import cn.com.poc.agent_application.entity.BizAgentApplicationMallEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.entity.BizMemberAgentApplicationCollectEntity;
import cn.com.poc.agent_application.service.BizAgentApplicationMallService;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.poc.agent_application.service.BizMemberAgentApplicationCollectService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class AgentApplicationMallServiceImpl implements AgentApplicationMallService {

    @Resource
    private BizAgentApplicationMallService bizAgentApplicationMallService;

    @Resource
    private BizMemberAgentApplicationCollectService bizMemberAgentApplicationCollectService;

    @Resource
    private BizAgentApplicationPublishService bizAgentApplicationPublishService;


    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRED)
    @Override
    public void collectOrCancelAgentInMall(Integer id) throws Exception {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new I18nMessageException("exception/user.not.login");
        }

        BizAgentApplicationMallEntity mallEntity = bizAgentApplicationMallService.get(id);
        if (mallEntity == null) {
            throw new I18nMessageException("exception/application.does.not.exist");
        }

        BizAgentApplicationPublishEntity publishEntity = bizAgentApplicationPublishService.get(mallEntity.getAgentPublishId());
        if (publishEntity == null) {
            throw new I18nMessageException("exception/publication.failed");
        }
        // 先判断当前应用被收藏了吗
        BizMemberAgentApplicationCollectEntity bizMemberAgentApplicationCollectEntity = new BizMemberAgentApplicationCollectEntity();
        bizMemberAgentApplicationCollectEntity.setMemberId(userBaseEntity.getUserId().intValue());
        bizMemberAgentApplicationCollectEntity.setAgentId(publishEntity.getAgentId());
        bizMemberAgentApplicationCollectEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizMemberAgentApplicationCollectEntity> collectEntities = bizMemberAgentApplicationCollectService.findByExample(bizMemberAgentApplicationCollectEntity, null);

        if (CollectionUtils.isEmpty(collectEntities) || CommonConstant.IsDeleted.N.equals(collectEntities.get(0).getIsCollect())) {   //如果没被收藏
            // 收藏该应用
            // 说明从来没收藏过
            if (CollectionUtils.isEmpty(collectEntities)) {
                // 在用户收藏表中添加数据
                BizMemberAgentApplicationCollectEntity entity = new BizMemberAgentApplicationCollectEntity();
                entity.setIsCollect(CommonConstant.IsDeleted.Y);
                entity.setMemberId(userBaseEntity.getUserId().intValue());
                entity.setAgentId(publishEntity.getAgentId());
                bizMemberAgentApplicationCollectService.save(entity);
            } else {  // 说明之前收藏过，则只需要做个修改
                BizMemberAgentApplicationCollectEntity collectEntity = collectEntities.get(0);
                collectEntity.setIsCollect(CommonConstant.IsDeleted.Y);
                bizMemberAgentApplicationCollectService.update(collectEntity);
            }
            // 在应用广场的应用中 添加收藏数
            mallEntity.setCollectNumber(mallEntity.getCollectNumber() + 1);
        } else {
            BizMemberAgentApplicationCollectEntity collectEntity = collectEntities.get(0);
            // 取消收藏该应用
            collectEntity.setIsCollect(CommonConstant.IsDeleted.N);
            bizMemberAgentApplicationCollectService.update(collectEntity);
            // 在应用广场的应用中 取消收藏数
            mallEntity.setCollectNumber(mallEntity.getCollectNumber() - 1);
        }
        bizAgentApplicationMallService.update(mallEntity);
    }

    @Override
    public void addClickNumber(Integer agentPublishId) throws Exception {
        BizAgentApplicationMallEntity mallEntity = bizAgentApplicationMallService.getByAgentPublishId(agentPublishId);
        if (mallEntity == null) {
            return;
        }
        mallEntity.setClickNumber(mallEntity.getClickNumber() + 1);
        bizAgentApplicationMallService.update(mallEntity);
    }

    @Override
    public BizAgentApplicationMallEntity getAgentPublishInfo(String agentId) throws Exception {
        BizAgentApplicationPublishEntity agentApplicationPublishEntity = bizAgentApplicationPublishService.getByAgentId(agentId);
        if (agentApplicationPublishEntity == null) {
            return null;
        }
        Integer publishId = agentApplicationPublishEntity.getId();
        BizAgentApplicationMallEntity mallEntity = bizAgentApplicationMallService.getByAgentPublishId(publishId);
        if (mallEntity == null) {
            mallEntity = new BizAgentApplicationMallEntity();
            mallEntity.setAgentPublishId(publishId);
        }
        return mallEntity;
    }
}
