package cn.com.poc.agent_application.constant;

public interface AgentApplicationConstants {

    interface AGENT_PUBLISH_STATUS {

        String DRAFT = "draft"; // 草稿

        String PUBLISH = "publish"; // 发布

        String UN_PUBLISH = "unPublish"; // 已下架

        static boolean isPublishStatus(String status) {
            return PUBLISH.equals(status) || DRAFT.equals(status) || UN_PUBLISH.equals(status);
        }

    }

    interface CONTINUOUS_QUESTION_STATUS {
        String DEFAULT = "default"; //默认
        String CUSTOMIZABLE = "customizable"; //自定义
        String CLOSE = "close";//关闭

        static boolean isQuestionStatus(String status) {
            return DEFAULT.equals(status) || CUSTOMIZABLE.equals(status) || CLOSE.equals(status);
        }
    }

    interface KNOWLEDGE_RESPONSE_TYPE {
        String DEFAULT = "default"; //ai回复
        String CUSTOM = "custom"; //自定义护肤

        static boolean isResponseType(String status) {
            return DEFAULT.equals(status) || CUSTOM.equals(status);
        }
    }


}
