package cn.com.poc.agent_application.rest;

import cn.com.poc.agent_application.dto.AgentApplicationPluginClassificationDto;
import cn.com.poc.agent_application.dto.AgentApplicationPluginDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.poc.agent_application.dto.BizAgentApplicationPluginDto;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Permission(Access.Safety)
public interface BizAgentApplicationPluginRest extends BaseRest {

    /**
     * 获取插件详情
     *
     * @param pluginId
     * @return
     * @throws Exception
     */
    AgentApplicationPluginDto getByPluginId(@RequestParam String pluginId);

    /**
     * 获取插件列表
     *
     * @param classification
     * @param pluginIds
     * @param query
     * @param pagingInfo
     * @return
     * @throws Exception
     */
    List<AgentApplicationPluginDto> getList(@RequestParam(required = false) String classification, @RequestParam(required = false) List<String> pluginIds, @RequestParam(required = false) String query, PagingInfo pagingInfo) throws Exception;

    /**
     * 插件分类列表
     */
    List<AgentApplicationPluginClassificationDto> classificationList();

}