package cn.com.poc.agent_application.rest.impl;

import cn.com.poc.agent_application.convert.BizAgentApplicationPluginConvert;
import cn.com.poc.agent_application.dto.AgentApplicationPluginClassificationDto;
import cn.com.poc.agent_application.dto.AgentApplicationPluginDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationPluginEntity;
import cn.com.poc.agent_application.query.AgentPluginQueryCondition;
import cn.com.poc.agent_application.query.AgentPluginQueryItem;
import cn.com.poc.agent_application.rest.BizAgentApplicationPluginRest;
import cn.com.poc.agent_application.service.BizAgentApplicationPluginService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.StringUtils;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

import static cn.com.poc.common.constant.XLangConstant.*;

@Component
public class BizAgentApplicationPluginRestImpl implements BizAgentApplicationPluginRest {

    @Resource
    private BizAgentApplicationPluginService bizAgentApplicationPluginService;

    @Override
    public AgentApplicationPluginDto getByPluginId(String pluginId) {
        BizAgentApplicationPluginEntity bizAgentApplicationPluginEntity = new BizAgentApplicationPluginEntity();
        bizAgentApplicationPluginEntity.setPluginId(pluginId);
        BizAgentApplicationPluginEntity entity = bizAgentApplicationPluginService.getInfoByPluginId(pluginId);
        return BizAgentApplicationPluginConvert.entityToDto(entity, BlContext.getCurrentLocaleLanguageToLowerCase());
    }

    @Override
    public List<AgentApplicationPluginDto> getList(String classification, List<String> pluginIds, String query, PagingInfo pagingInfo) throws Exception {
        AgentPluginQueryCondition condition = new AgentPluginQueryCondition();
        condition.setPluginIds(pluginIds);
        condition.setClassification(classification);
        if (StringUtils.isNotBlank(query)) {
            switch (BlContext.getCurrentLocaleLanguageToLowerCase()) {
                case ZH_CN:
                    condition.setQueryZHCN(query);
                    break;
                case ZH_TW:
                    condition.setQueryZHTW(query);
                    break;
                case EN:
                    condition.setQueryEN(query);
                    break;
            }
        }
        List<AgentPluginQueryItem> agentPluginQueryItems = bizAgentApplicationPluginService.agentPluginQuery(condition, pagingInfo);
        return BizAgentApplicationPluginConvert.itemsToPluginDtos(agentPluginQueryItems, BlContext.getCurrentLocaleLanguageToLowerCase());
    }

    @Override
    public List<AgentApplicationPluginClassificationDto> classificationList() {
        BizAgentApplicationPluginEntity bizAgentApplicationPluginEntity = new BizAgentApplicationPluginEntity();
        bizAgentApplicationPluginEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationPluginEntity> entities = bizAgentApplicationPluginService.findByExample(bizAgentApplicationPluginEntity, null);
        return BizAgentApplicationPluginConvert.entitiesToClassificationDtos(entities.stream().filter(entity -> !"system".equals(entity.getClassification())).collect(Collectors.toList()), BlContext.getCurrentLocaleLanguageToLowerCase());
    }
}