package cn.com.poc.agent_application.rest.impl;	

import java.util.List;
import javax.annotation.Resource;

import org.springframework.stereotype.Component;
import cn.com.poc.agent_application.rest.BizAgentApplicationPublishRest;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.poc.agent_application.dto.BizAgentApplicationPublishDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.agent_application.convert.BizAgentApplicationPublishConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAgentApplicationPublishRestImpl implements BizAgentApplicationPublishRest {

   	@Resource
    private BizAgentApplicationPublishService bizAgentApplicationPublishService;

	public BizAgentApplicationPublishDto getById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
 		return BizAgentApplicationPublishConvert.entityToDto(bizAgentApplicationPublishService.get(id));
   	}
    
   	public List<BizAgentApplicationPublishDto> getList(BizAgentApplicationPublishDto dto,PagingInfo pagingInfo) throws Exception{
       	return bizAgentApplicationPublishService
		        .findByExample(BizAgentApplicationPublishConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAgentApplicationPublishConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAgentApplicationPublishDto save(BizAgentApplicationPublishDto dto) throws Exception{
		Assert.notNull(dto);
		BizAgentApplicationPublishEntity entity = BizAgentApplicationPublishConvert.dtoToEntity(dto);
       	return BizAgentApplicationPublishConvert.entityToDto(bizAgentApplicationPublishService.save(entity));
   	}

    public void deletedById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
		bizAgentApplicationPublishService.deletedById(id);
	}
}