package cn.com.poc.agent_application.service.impl;

import cn.com.poc.agent_application.query.*;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.model.BizAgentApplicationDialoguesRecordModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationDialoguesRecordEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationDialoguesRecordConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationDialoguesRecordRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAgentApplicationDialoguesRecordServiceImpl extends BaseServiceImpl
        implements BizAgentApplicationDialoguesRecordService {

    @Resource
    private BizAgentApplicationDialoguesRecordRepository repository;

    public BizAgentApplicationDialoguesRecordEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationDialoguesRecordModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAgentApplicationDialoguesRecordConvert.modelToEntity(model);
    }


    public List<BizAgentApplicationDialoguesRecordEntity> findByExample(BizAgentApplicationDialoguesRecordEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAgentApplicationDialoguesRecordEntity> result = new ArrayList<BizAgentApplicationDialoguesRecordEntity>();
        BizAgentApplicationDialoguesRecordModel model = new BizAgentApplicationDialoguesRecordModel();
        if (example != null) {
            model = BizAgentApplicationDialoguesRecordConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAgentApplicationDialoguesRecordModel> models = this.repository.findByExample(model, "timestamp asc", pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationDialoguesRecordConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<BizAgentApplicationDialoguesRecordEntity> findByExample(BizAgentApplicationDialoguesRecordEntity example) throws Exception {
        List<BizAgentApplicationDialoguesRecordEntity> result = new ArrayList<BizAgentApplicationDialoguesRecordEntity>();
        BizAgentApplicationDialoguesRecordModel model = new BizAgentApplicationDialoguesRecordModel();
        if (example != null) {
            model = BizAgentApplicationDialoguesRecordConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAgentApplicationDialoguesRecordModel> models = this.repository.findByExample(model, "timestamp desc", new PagingInfo());
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationDialoguesRecordConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationDialoguesRecordEntity save(BizAgentApplicationDialoguesRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAgentApplicationDialoguesRecordModel model = BizAgentApplicationDialoguesRecordConvert.entityToModel(entity);
        BizAgentApplicationDialoguesRecordModel saveModel = this.repository.save(model);
        return BizAgentApplicationDialoguesRecordConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationDialoguesRecordEntity update(BizAgentApplicationDialoguesRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId());
        BizAgentApplicationDialoguesRecordModel model = this.repository.get(entity.getId());

        if (entity.getRole() != null) {
            model.setRole(entity.getRole());
        }
        if (entity.getAgentId() != null) {
            model.setAgentId(entity.getAgentId());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getContent() != null) {
            model.setContent(entity.getContent());
        }
        if (entity.getReasoningContent() != null) {
            model.setReasoningContent(entity.getReasoningContent());
        }
        if (entity.getTimestamp() != null) {
            model.setTimestamp(entity.getTimestamp());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizAgentApplicationDialoguesRecordModel saveModel = this.repository.save(model);
        return BizAgentApplicationDialoguesRecordConvert.modelToEntity(saveModel);
    }

    public void deletedById(Long id) {
        Assert.notNull(id);
        BizAgentApplicationDialoguesRecordModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<DialogsIdsQueryByAgentIdQueryItem> queryDialogsIds(String agentId) {
        DialogsIdsQueryByAgentIdQueryCondition condition = new DialogsIdsQueryByAgentIdQueryCondition();
        condition.setAgentId(agentId);
        return this.sqlDao.query(condition, DialogsIdsQueryByAgentIdQueryItem.class);
    }

    @Override
    public List<MemberDialoguesQueryItem> memberDialoguesQuery(Long memberId, PagingInfo pagingInfo) {
        MemberDialoguesQueryCondition condition = new MemberDialoguesQueryCondition();
        condition.setMemberId(memberId);
        return this.sqlDao.query(condition, MemberDialoguesQueryItem.class, pagingInfo);
    }

    @Override
    public boolean batchDeleteByDialogueId(List<String> dialogueIds) {
        Assert.notEmpty(dialogueIds);
        List<BizAgentApplicationDialoguesRecordModel> delModels = new ArrayList<>();
        for (String dialogueId : dialogueIds) {
            BizAgentApplicationDialoguesRecordModel model = new BizAgentApplicationDialoguesRecordModel();
            model.setDialogsId(dialogueId);
            model.setIsDeleted(CommonConstant.IsDeleted.N);
            List<BizAgentApplicationDialoguesRecordModel> models = this.repository.findByExample(model);
            if (CollectionUtils.isNotEmpty(models)) {
                for (BizAgentApplicationDialoguesRecordModel bizAgentApplicationDialoguesRecordModel : models) {
                    bizAgentApplicationDialoguesRecordModel.setIsDeleted(CommonConstant.IsDeleted.Y);
                    delModels.add(bizAgentApplicationDialoguesRecordModel);
                }
            }
        }
        this.repository.saveAll(delModels);
        return true;
    }

    @Override
    public List<AgentApplicationDialoguesRecordQueryItem> getDialogueRecord(String dialogueId, PagingInfo pagingInfo) {
        AgentApplicationDialoguesRecordQueryCondition condition = new AgentApplicationDialoguesRecordQueryCondition();
        condition.setDialogueId(dialogueId);
        return this.sqlDao.query(condition, AgentApplicationDialoguesRecordQueryItem.class, pagingInfo);
    }
}