package cn.com.poc.agent_application.service.impl;

import cn.com.poc.agent_application.query.AgentPluginQueryCondition;
import cn.com.poc.agent_application.query.AgentPluginQueryItem;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationPluginService;
import cn.com.poc.agent_application.model.BizAgentApplicationPluginModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationPluginEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationPluginConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationPluginRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAgentApplicationPluginServiceImpl extends BaseServiceImpl
        implements BizAgentApplicationPluginService {

    @Resource
    private BizAgentApplicationPluginRepository repository;

    public BizAgentApplicationPluginEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationPluginModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAgentApplicationPluginConvert.modelToEntity(model);
    }


    public List<BizAgentApplicationPluginEntity> findByExample(BizAgentApplicationPluginEntity example, PagingInfo pagingInfo) {
        List<BizAgentApplicationPluginEntity> result = new ArrayList<BizAgentApplicationPluginEntity>();
        BizAgentApplicationPluginModel model = new BizAgentApplicationPluginModel();
        if (example != null) {
            model = BizAgentApplicationPluginConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAgentApplicationPluginModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationPluginConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationPluginEntity save(BizAgentApplicationPluginEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAgentApplicationPluginModel model = BizAgentApplicationPluginConvert.entityToModel(entity);
        BizAgentApplicationPluginModel saveModel = this.repository.save(model);
        return BizAgentApplicationPluginConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationPluginEntity update(BizAgentApplicationPluginEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAgentApplicationPluginModel model = this.repository.get(entity.getId());

        if (entity.getClassification() != null) {
            model.setClassification(entity.getClassification());
        }
        if (entity.getPluginId() != null) {
            model.setPluginId(entity.getPluginId());
        }
        if (entity.getZhCnTitle() != null) {
            model.setZhCnTitle(entity.getZhCnTitle());
        }
        if (entity.getZhTwTitle() != null) {
            model.setZhTwTitle(entity.getZhTwTitle());
        }
        if (entity.getEnTitle() != null) {
            model.setEnTitle(entity.getEnTitle());
        }
        if (entity.getZhCnDesc() != null) {
            model.setZhCnDesc(entity.getZhCnDesc());
        }
        if (entity.getZhTwDesc() != null) {
            model.setZhTwDesc(entity.getZhTwDesc());
        }
        if (entity.getEnDesc() != null) {
            model.setEnDesc(entity.getEnDesc());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizAgentApplicationPluginModel saveModel = this.repository.save(model);
        return BizAgentApplicationPluginConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationPluginModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public BizAgentApplicationPluginEntity getInfoByPluginId(String pluginId) {
        BizAgentApplicationPluginModel model = new BizAgentApplicationPluginModel();
        model.setPluginId(pluginId);
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationPluginModel> models = this.repository.findByExample(model, null);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizAgentApplicationPluginConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    @Override
    public List<AgentPluginQueryItem> agentPluginQuery(AgentPluginQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, AgentPluginQueryItem.class, pagingInfo);
    }
}