package cn.com.poc.ai_bi.aggregate;

/**
 * 智数：智能问数生成式BI服务
 *
 * @author alex.yao
 * @date 2025/6/20
 */
public interface AiBiService {

    /**
     * 调用智能问数生成式BI服务
     *
     * @param dialoguesId  对话id
     * @param input        问题
     * @param fileUrl      文件地址
     * @param knowledgeIds 知识库ids
     * @param databaseIds  数据库ids
     * @param userId       用户id
     */
    @Deprecated
    void call(String dialoguesId, String input, String fileUrl, Integer[] knowledgeIds, Integer[] databaseIds, Long userId) throws Exception;


    /**
     * 调用智能问数生成式BI服务
     *
     * @param dialoguesId  对话id
     * @param input        问题
     * @param fileUrl      文件地址
     * @param knowledgeIds 知识库ids
     * @param databaseIds  数据库ids
     * @param userId       用户id
     */
    void callV2(String dialoguesId, String input, String fileUrl, Integer[] knowledgeIds, Integer[] databaseIds, Long userId) throws Exception;


    /**
     * 生成洞察报告
     *
     * @param dialoguesId
     * @param fileUrl
     * @param SQL
     * @param result
     * @param question
     */
    void generateInsightReport(String dialoguesId, String fileUrl, String SQL, String result, String question) throws Exception;

    /**
     * 获取洞察报告
     *
     * @param dialoguesId
     */
    String getInsightReport(String dialoguesId);
}
