package cn.com.poc.ai_bi.rest;

import cn.com.poc.ai_bi.dto.AIBiExampleDto;
import cn.com.poc.ai_bi.dto.AiBiDialoguesDto;
import cn.com.poc.ai_bi.dto.AiBiGenerateInsightReportDto;
import cn.com.poc.common.utils.SSEUtil;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.security.core.parameters.P;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.IOException;

/**
 * 智数：智能问数生成式BI服务接口
 *
 * @author alex.yao
 * @date 2025/6/20
 */
@Permission(Access.Safety)
public interface AiBiRest extends BaseRest {


    /**
     * 调用AI问数
     */
    void call(@RequestBody AiBiDialoguesDto dto) throws Exception;

    /**
     * 生成洞察报告
     * <p>
     * sse
     *
     * @param dto
     */
    void generateInsightReport(@RequestBody AiBiGenerateInsightReportDto dto) throws Exception;

    /**
     * 获取洞察报告
     *
     * @param dialoguesId
     */
    String getInsightReport(@RequestParam String dialoguesId);

    /**
     * 获取示例
     * @return
     * @throws Exception
     */
    AIBiExampleDto getExample() throws Exception;
}
