package cn.com.poc.ai_bi.rest.impl;

import cn.com.poc.ai_bi.aggregate.AiBiService;
import cn.com.poc.ai_bi.convert.BizAiBiExampleConvert;
import cn.com.poc.ai_bi.dto.AIBiExampleDto;
import cn.com.poc.ai_bi.dto.AiBiDialoguesDto;
import cn.com.poc.ai_bi.dto.AiBiGenerateInsightReportDto;
import cn.com.poc.ai_bi.dto.BizAiBiExampleDto;
import cn.com.poc.ai_bi.entity.BizAiBiExampleEntity;
import cn.com.poc.ai_bi.rest.AiBiRest;
import cn.com.poc.ai_bi.service.BizAiBiExampleService;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author alex.yao
 * @date 2025/6/20
 */

@Component
public class AiBiRestImpl implements AiBiRest {

    @Resource
    private AiBiService aiBiService;


    @Resource
    private BizAiBiExampleService bizAiBiExampleService;

    @Override
    public void call(AiBiDialoguesDto dto) throws Exception {
        Assert.notNull(dto);
        Assert.notBlank(dto.getDialoguesId(), "对话id不能为空");
        Assert.notBlank(dto.getInput(), "输入内容不能为空");

        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (ObjectUtils.isEmpty(userBaseEntity)) {
            throw new BusinessException("用户未登录");
        }
        aiBiService.callV2(dto.getDialoguesId(),
                dto.getInput(),
                dto.getFileUrl(),
                dto.getKnowledgeIds(),
                dto.getDatabaseIds(),
                userBaseEntity.getUserId());
    }

    @Override
    public void generateInsightReport(AiBiGenerateInsightReportDto dto) throws Exception {
        Assert.notBlank(dto.getDialoguesId(), "对话id不能为空");
        Assert.notBlank(dto.getResult(), "数据集不能为空");
        Assert.notBlank(dto.getQuestion(), "问题不能为空");
        Assert.isTrue(StringUtils.isNotBlank(dto.getFileUrl()) || StringUtils.isNotBlank(dto.getSQL()), "SQL 或 fileUrl 不能同时为空");
        aiBiService.generateInsightReport(dto.getDialoguesId(), dto.getFileUrl(), dto.getSQL(), dto.getResult(), dto.getQuestion());
    }

    @Override
    public String getInsightReport(String dialoguesId) {
        Assert.notBlank(dialoguesId, "对话id不能为空");
        return aiBiService.getInsightReport(dialoguesId);
    }

    @Override
    public AIBiExampleDto getExample() throws Exception {
        List<BizAiBiExampleDto> exampleDtos = bizAiBiExampleService.findByExample(new BizAiBiExampleEntity(), null)
                .stream()
                .map(BizAiBiExampleConvert::entityToDto)
                .collect(Collectors.toList());

        AIBiExampleDto aiBiExampleDto = new AIBiExampleDto();
        aiBiExampleDto.setDatabaseExamples(exampleDtos.stream().filter(dto -> dto.getDataType().equals("FILE")).collect(Collectors.toList()));
        aiBiExampleDto.setFileExamples(exampleDtos.stream().filter(dto -> dto.getDataType().equals("DATA_BASE")).collect(Collectors.toList()));
        aiBiExampleDto.setFeaturedExamples(exampleDtos.stream().filter(dto -> dto.getDataType().equals("FEATURED")).collect(Collectors.toList()));
        return aiBiExampleDto;
    }
}
