package cn.com.poc.ai_bi.service.impl;	

import cn.com.poc.ai_bi.convert.BizAiBiExampleConvert;
import cn.com.poc.ai_bi.entity.BizAiBiExampleEntity;
import cn.com.poc.ai_bi.model.BizAiBiExampleModel;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.ai_bi.service.BizAiBiExampleService;
import cn.com.poc.ai_bi.repository.BizAiBiExampleRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiBiExampleServiceImpl extends BaseServiceImpl
 			 implements BizAiBiExampleService {
   
   @Resource
   private BizAiBiExampleRepository repository;
    			 
   public BizAiBiExampleEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiBiExampleModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAiBiExampleConvert.modelToEntity(model);
   }

       
   public List<BizAiBiExampleEntity> findByExample(BizAiBiExampleEntity example, PagingInfo pagingInfo) throws Exception{
        List<BizAiBiExampleEntity> result = new  ArrayList<BizAiBiExampleEntity>();
        BizAiBiExampleModel model = new BizAiBiExampleModel();
        if (example != null){
            model = BizAiBiExampleConvert.entityToModel(example);
        }
        List<BizAiBiExampleModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiBiExampleConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiBiExampleEntity save(BizAiBiExampleEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        BizAiBiExampleModel model = BizAiBiExampleConvert.entityToModel(entity);
        BizAiBiExampleModel saveModel =  this.repository.save(model);
        return BizAiBiExampleConvert.modelToEntity(saveModel);
    }

    public BizAiBiExampleEntity update(BizAiBiExampleEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAiBiExampleModel model = this.repository.get(entity.getId());

       if (entity.getTitle() != null){
        model.setTitle(entity.getTitle());
       }
       if (entity.getDataType() != null){
        model.setDataType(entity.getDataType());
       }
       if (entity.getDataRelation() != null){
        model.setDataRelation(entity.getDataRelation());
       }
       if (entity.getExampleDesc() != null){
        model.setExampleDesc(entity.getExampleDesc());
       }
       if (entity.getQuestion() != null){
        model.setQuestion(entity.getQuestion());
       }
        BizAiBiExampleModel saveModel =  this.repository.save(model);
        return BizAiBiExampleConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiBiExampleModel model =  this.repository.get(id);
        if (model != null){
       }
   }
    
}