package cn.com.poc.ai_data_audit.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.ai_data_audit.rest.BizAiDataAuditFileRest;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditFileService;
import cn.com.poc.ai_data_audit.dto.BizAiDataAuditFileDto;
import cn.com.poc.ai_data_audit.entity.BizAiDataAuditFileEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.ai_data_audit.convert.BizAiDataAuditFileConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAiDataAuditFileRestImpl implements BizAiDataAuditFileRest {
   
   	@Resource
    private BizAiDataAuditFileService service;

	@Override
	public List<BizAiDataAuditFileDto> getFileList(BizAiDataAuditFileDto dto) throws Exception {
		return service
				.findByExample(BizAiDataAuditFileConvert.dtoToEntity(dto),null)
				.stream()
				.map(BizAiDataAuditFileConvert::entityToDto)
				.collect(Collectors.toList());
	}

	public BizAiDataAuditFileDto getById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
 		return BizAiDataAuditFileConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizAiDataAuditFileDto> getList(BizAiDataAuditFileDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizAiDataAuditFileConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAiDataAuditFileConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAiDataAuditFileDto save(BizAiDataAuditFileDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiDataAuditFileEntity entity = BizAiDataAuditFileConvert.dtoToEntity(dto);
       	return BizAiDataAuditFileConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizAiDataAuditFileDto update(BizAiDataAuditFileDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiDataAuditFileEntity entity = BizAiDataAuditFileConvert.dtoToEntity(dto);
       	return BizAiDataAuditFileConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}