package cn.com.poc.ai_data_audit.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.ai_data_audit.rest.BizAiDataAuditRuleRest;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditRuleService;
import cn.com.poc.ai_data_audit.dto.BizAiDataAuditRuleDto;
import cn.com.poc.ai_data_audit.entity.BizAiDataAuditRuleEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.ai_data_audit.convert.BizAiDataAuditRuleConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAiDataAuditRuleRestImpl implements BizAiDataAuditRuleRest {
   
   	@Resource
    private BizAiDataAuditRuleService service;
    			 
	public BizAiDataAuditRuleDto getById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
 		return BizAiDataAuditRuleConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizAiDataAuditRuleDto> getList(BizAiDataAuditRuleDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizAiDataAuditRuleConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAiDataAuditRuleConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAiDataAuditRuleDto save(BizAiDataAuditRuleDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiDataAuditRuleEntity entity = BizAiDataAuditRuleConvert.dtoToEntity(dto);
       	return BizAiDataAuditRuleConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizAiDataAuditRuleDto update(BizAiDataAuditRuleDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiDataAuditRuleEntity entity = BizAiDataAuditRuleConvert.dtoToEntity(dto);
       	return BizAiDataAuditRuleConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Integer id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}