package cn.com.poc.ai_data_audit.rest.impl;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;

import cn.com.poc.ai_data_audit.convert.BizAiDataAuditFileConvert;
import cn.com.poc.ai_data_audit.dto.BizAiDataAuditFileDto;
import cn.com.poc.ai_data_audit.dto.BizAiDataAuditTaskDeleteDto;
import cn.com.poc.ai_data_audit.entity.BizAiDataAuditFileEntity;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditFileService;
import cn.com.poc.common.utils.BlContext;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;
import cn.com.poc.ai_data_audit.rest.BizAiDataAuditTaskRest;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditTaskService;
import cn.com.poc.ai_data_audit.dto.BizAiDataAuditTaskDto;
import cn.com.poc.ai_data_audit.entity.BizAiDataAuditTaskEntity;
import cn.com.poc.ai_data_audit.convert.BizAiDataAuditTaskConvert;

import java.util.stream.Collectors;

import org.springframework.util.Assert;

@Component
public class BizAiDataAuditTaskRestImpl implements BizAiDataAuditTaskRest {

    @Resource
    private BizAiDataAuditTaskService bizAiDataAuditTaskService;

    @Resource
    private BizAiDataAuditFileService bizAiDataAuditFileService;

    @Override
    public List<BizAiDataAuditTaskDto> getTaskList() throws Exception {
        BizAiDataAuditTaskEntity bizAiDataAuditTaskEntity = new BizAiDataAuditTaskEntity();

        Integer memberId = BlContext.getCurrentUser().getUserId().intValue();
        if (memberId == null) {
            return null;
        }
        bizAiDataAuditTaskEntity.setMemberId(memberId);
        List<BizAiDataAuditTaskEntity> bizAiDataAuditTaskEntityList = bizAiDataAuditTaskService.findByExample(bizAiDataAuditTaskEntity, null);
        for (BizAiDataAuditTaskEntity aiDataAuditTaskEntity : bizAiDataAuditTaskEntityList) {
            aiDataAuditTaskEntity.setAuditResult(null);
        }
        return bizAiDataAuditTaskEntityList.stream().sorted(Comparator.comparing(BizAiDataAuditTaskEntity::getDataAuditTaskId).reversed()).map(BizAiDataAuditTaskConvert::entityToDto).collect(Collectors.toList());
    }

    @Override
    public BizAiDataAuditTaskDto getByTaskId(Long taskId) throws Exception {
        Assert.notNull(taskId, "taskId can not be null");
        BizAiDataAuditTaskEntity bizAiDataAuditTaskEntity = bizAiDataAuditTaskService.get(taskId);
        if (bizAiDataAuditTaskEntity == null) {
            throw new Exception("the task can not be found");
        }
        BizAiDataAuditTaskDto bizAiDataAuditTaskDto = BizAiDataAuditTaskConvert.entityToDto(bizAiDataAuditTaskEntity);
        BizAiDataAuditFileEntity entity = new BizAiDataAuditFileEntity();
        entity.setTaskId(taskId);
        List<BizAiDataAuditFileDto> bizAiDataAuditFileDtos = bizAiDataAuditFileService.findByExample(entity, null)
                .stream()
                .map(BizAiDataAuditFileConvert::entityToDto)
                .collect(Collectors.toList());

        bizAiDataAuditTaskDto.setBizAiDataAuditFileDtoList(bizAiDataAuditFileDtos);

        return bizAiDataAuditTaskDto;
    }

    @Override
    public void delete(BizAiDataAuditTaskDeleteDto dto) throws Exception {
        if (CollectionUtils.isEmpty(dto.getTaskIdList())) {
            throw new Exception("the task can not be found");
        }
        for (Long taskId : dto.getTaskIdList()) {
            bizAiDataAuditTaskService.delete(taskId);
        }
    }
}