package cn.com.poc.ai_data_audit.rest.impl;

import cn.com.poc.ai_data_audit.dto.*;
import cn.com.poc.ai_data_audit.rest.DataAuditRest;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditTaskService;
import cn.com.poc.ai_data_audit.service.DataAuditService;
import cn.com.poc.common.utils.RandomUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author：Roger Wu
 * @name：FileUploadDtoImpl
 * @Date：2025-10-29 21:29
 */
@Component
public class DataAuditRestImpl implements DataAuditRest {

    @Resource
    private BizAiDataAuditTaskService bizAiDataAuditTaskService;

    @Resource
    private DataAuditService dataAuditService;

    @Override
    public List<FileUploadReturnDto> fileUpload(List<FileUploadDto> fileUploadDtoList) throws Exception {
        if (CollectionUtils.isEmpty(fileUploadDtoList)) {
            throw new Exception("please upload files");
        }
        return dataAuditService.fileUploadAndProcessing(fileUploadDtoList);
    }

    @Override
    public void createDataAuditTask(FileUploadConfirmDto fileUploadConfirmDto) throws Exception {
        String taskName = "Task-" + RandomUtil.produceStringAndNumber(6);
        bizAiDataAuditTaskService.createDataAuditTask(taskName, fileUploadConfirmDto);
    }

    /**
     * 对话
     *
     * @param
     * @param
     * @throws Exception
     */
    @Override
    public DataAuditResult call(DataAuditCallDto dataAuditCallDto) throws Exception {
        return dataAuditService.call(dataAuditCallDto);
    }


}
