package cn.com.poc.ai_data_audit.scheduler;

import cn.com.poc.ai_data_audit.constants.DataAuditConstants;
import cn.com.poc.ai_data_audit.entity.BizAiDataAuditTaskEntity;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditTaskService;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.message.entity.AirportTaskCreateMessage;
import cn.com.poc.message.service.AirportProducerService;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/10/30
 */
@Component
public class AiDataAuditScheduler {

    @Resource
    private RedisService redisService;

    @Resource
    private BizAiDataAuditTaskService bizAiDataAuditTaskService;
    @Resource
    private AirportProducerService airportProducerService;

    @Scheduled(fixedDelay = 1000 * 30)
    public void aiDataAudit() throws Exception {
        BizAiDataAuditTaskEntity bizAiDataAuditTaskEntity = new BizAiDataAuditTaskEntity();
        bizAiDataAuditTaskEntity.setStatus(DataAuditConstants.status.status_process);
        bizAiDataAuditTaskEntity.setIsDeleted("N");
        List<BizAiDataAuditTaskEntity> taskEntities = bizAiDataAuditTaskService.findByExample(bizAiDataAuditTaskEntity, null);
        for (BizAiDataAuditTaskEntity taskEntity : taskEntities) {
            Long taskId = taskEntity.getDataAuditTaskId();
            if (redisService.hasKey("AI_DATA_AUDIT_TASK:" + taskId)) {
                Object value = redisService.get("AI_DATA_AUDIT_TASK:" + taskId);
                if ("Get".equals(value.toString())) {
                    AirportTaskCreateMessage airportTaskCreateMessage = new AirportTaskCreateMessage();
                    airportTaskCreateMessage.setTaskId(taskId);
                    airportProducerService.createTask(airportTaskCreateMessage);
                }
            }
        }
    }
}
