package cn.com.poc.ai_data_audit.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditFileService;
import cn.com.poc.ai_data_audit.model.BizAiDataAuditFileModel;
import cn.com.poc.ai_data_audit.entity.BizAiDataAuditFileEntity;
import cn.com.poc.ai_data_audit.convert.BizAiDataAuditFileConvert;
import cn.com.poc.ai_data_audit.repository.BizAiDataAuditFileRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.hutool.crypto.digest.MD5;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiDataAuditFileServiceImpl extends BaseServiceImpl
 			 implements BizAiDataAuditFileService {
   
   @Resource
   private BizAiDataAuditFileRepository repository;
    			 
   public BizAiDataAuditFileEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizAiDataAuditFileModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizAiDataAuditFileConvert.modelToEntity(model);
   }

       
   public List<BizAiDataAuditFileEntity> findByExample(BizAiDataAuditFileEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiDataAuditFileEntity> result = new  ArrayList<BizAiDataAuditFileEntity>();
        BizAiDataAuditFileModel model = new BizAiDataAuditFileModel();
        if (example != null){
            model = BizAiDataAuditFileConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAiDataAuditFileModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiDataAuditFileConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiDataAuditFileEntity save(BizAiDataAuditFileEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setDataAuditFileId(null);
        entity.setIsDeleted("N");
        BizAiDataAuditFileModel model = BizAiDataAuditFileConvert.entityToModel(entity);
        BizAiDataAuditFileModel saveModel =  this.repository.save(model);
        return BizAiDataAuditFileConvert.modelToEntity(saveModel);
    }

    public BizAiDataAuditFileEntity update(BizAiDataAuditFileEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getDataAuditFileId(),"update pk can not be null");
        BizAiDataAuditFileModel model = this.repository.get(entity.getDataAuditFileId());

       if (entity.getTaskId() != null){
        model.setTaskId(entity.getTaskId());
       }
       if (entity.getOrginalTemplateCode() != null){
        model.setOrginalTemplateCode(entity.getOrginalTemplateCode());
       }
       if (entity.getOrginalTemplateName() != null){
        model.setOrginalTemplateName(entity.getOrginalTemplateName());
       }
       if (entity.getUploadFileName() != null){
        model.setUploadFileName(entity.getUploadFileName());
       }
       if (entity.getUploadFileUrl() != null){
        model.setUploadFileUrl(entity.getUploadFileUrl());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizAiDataAuditFileModel saveModel =  this.repository.save(model);
        return BizAiDataAuditFileConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizAiDataAuditFileModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }

    @Override
    public void batchSavedFile(List<BizAiDataAuditFileEntity> bizAiDataAuditFileEntityList) throws Exception {
        if (CollectionUtils.isEmpty(bizAiDataAuditFileEntityList)) {
            throw new Exception("please upload files");
        }
        for (BizAiDataAuditFileEntity bizAiDataAuditFileEntity : bizAiDataAuditFileEntityList) {
            save(bizAiDataAuditFileEntity);
        }
    }

}