package cn.com.poc.ai_data_audit.service.impl;

import cn.com.poc.ai_data_audit.query.AiDataAuditRuleQueryCondition;
import cn.com.poc.ai_data_audit.query.AiDataAuditRuleQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.ai_data_audit.service.BizAiDataAuditRuleService;
import cn.com.poc.ai_data_audit.model.BizAiDataAuditRuleModel;
import cn.com.poc.ai_data_audit.entity.BizAiDataAuditRuleEntity;
import cn.com.poc.ai_data_audit.convert.BizAiDataAuditRuleConvert;
import cn.com.poc.ai_data_audit.repository.BizAiDataAuditRuleRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAiDataAuditRuleServiceImpl extends BaseServiceImpl
        implements BizAiDataAuditRuleService {

    @Resource
    private BizAiDataAuditRuleRepository repository;

    public BizAiDataAuditRuleEntity get(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAiDataAuditRuleModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAiDataAuditRuleConvert.modelToEntity(model);
    }


    public List<BizAiDataAuditRuleEntity> findByExample(BizAiDataAuditRuleEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAiDataAuditRuleEntity> result = new ArrayList<BizAiDataAuditRuleEntity>();
        BizAiDataAuditRuleModel model = new BizAiDataAuditRuleModel();
        if (example != null) {
            model = BizAiDataAuditRuleConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAiDataAuditRuleModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiDataAuditRuleConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiDataAuditRuleEntity save(BizAiDataAuditRuleEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setDataAuditRuleId(null);
        entity.setIsDeleted("N");
        BizAiDataAuditRuleModel model = BizAiDataAuditRuleConvert.entityToModel(entity);
        BizAiDataAuditRuleModel saveModel = this.repository.save(model);
        return BizAiDataAuditRuleConvert.modelToEntity(saveModel);
    }

    public BizAiDataAuditRuleEntity update(BizAiDataAuditRuleEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getDataAuditRuleId(), "update pk can not be null");
        BizAiDataAuditRuleModel model = this.repository.get(entity.getDataAuditRuleId());

        if (entity.getDataAuditRuleType() != null) {
            model.setDataAuditRuleType(entity.getDataAuditRuleType());
        }
        if (entity.getFirstFile() != null) {
            model.setFirstFile(entity.getFirstFile());
        }
        if (entity.getFirstField() != null) {
            model.setFirstField(entity.getFirstField());
        }
        if (entity.getSecondFile() != null) {
            model.setSecondFile(entity.getSecondFile());
        }
        if (entity.getSecondField() != null) {
            model.setSecondField(entity.getSecondField());
        }
        if (entity.getRuleDesc() != null) {
            model.setRuleDesc(entity.getRuleDesc());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizAiDataAuditRuleModel saveModel = this.repository.save(model);
        return BizAiDataAuditRuleConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAiDataAuditRuleModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<AiDataAuditRuleQueryItem> aiDataAuditRuleQueryItemList(AiDataAuditRuleQueryCondition condition, PagingInfo pagingInfo) throws Exception {
        return this.sqlDao.query(condition, AiDataAuditRuleQueryItem.class, pagingInfo);
    }
}