package cn.com.poc.ai_dialogues.constant;

import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/6/19
 */
public enum AiDialoguesTypeEnum {

    PORTAL("portal", "门户页对话"),

    LONG_TEXT_DOCUMENT("long_text_document", "长文本文档"),

    AI_WRITING("ai_writing", "AI写作"),

    AI_BI("ai_bi", "智能问数"),

    AI_FINANCE("ai_finance", "AI财务"),

    LEGAL_AFFAIRS("legal_affairs", "法务问答"),

    LEGAL_DOCUMENT_WRITING("legal_document_writing", "智写-法律文书写作"),

    AI_LEGAL_DOCUMENT_WRITING("ai_legal_document_writing", "智写-法律文书ai写作"),

    TEMPLATE_LEGAL_DOCUMENT_WRITING("template_legal_document_writing", "智写-法律文书模板写作"),

    TRAVEL_BUSINESS("travel_business", "旅游业务"),

    MEETING_ASSISTANT("meeting_assistant","会议助手"),

    LEGISLATIVE_DOCUMENT_WRITING("legislative_document_writing","立案调查"),

    CAR_INSURANCE("car_insurance","车辆保险"),


    CAR_RECOMMEND("car_recommend","车辆推荐"),


    DATA_AUDIT("data_audit","数据校验"),

    ;

    private final String type;

    private final String desc;

    AiDialoguesTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


    public static AiDialoguesTypeEnum getByType(String type) {
        for (AiDialoguesTypeEnum aiDialoguesTypeEnum : AiDialoguesTypeEnum.values()) {
            if (aiDialoguesTypeEnum.getType().equals(type)) {
                return aiDialoguesTypeEnum;
            }
        }
        return null;
    }

}
