package cn.com.poc.ai_dialogues.rest.impl;

import cn.com.poc.ai_dialogues.aggregate.AiDialoguesService;
import cn.com.poc.ai_dialogues.constant.AiDialoguesTypeEnum;
import cn.com.poc.ai_dialogues.dto.AiDialoguesCallDto;
import cn.com.poc.ai_dialogues.dto.AiDialoguesRecordDto;
import cn.com.poc.ai_dialogues.dto.BatchDelAiDialoguesDto;
import cn.com.poc.ai_dialogues.rest.AiDialoguesRest;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.expose.dto.DialoguesContextDto;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.hutool.core.util.ObjectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Component
public class AiDialoguesRestImpl implements AiDialoguesRest {

    @Resource
    private AiDialoguesService aiDialoguesService;

    @Override
    public String create(String fileUrl, String type) throws Exception {
        Assert.notBlank(type, "对话类型不能为空");
        Assert.isTrue(AiDialoguesTypeEnum.getByType(type) != null, "对话类型不存在");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (ObjectUtil.isEmpty(userBaseEntity)) {
            throw new BusinessException("用户未登录");
        }
        if (StringUtils.isNotBlank(fileUrl)) {
            return aiDialoguesService.create(AiDialoguesTypeEnum.getByType(type), fileUrl, userBaseEntity.getUserId());
        }
        return aiDialoguesService.create(AiDialoguesTypeEnum.getByType(type), userBaseEntity.getUserId());
    }

    @Override
    public List<AiDialoguesRecordDto> getList(List<String> typeList) throws Exception {
        if (CollectionUtils.isEmpty(typeList)) {
            throw new BusinessException("对话类型不能为空");
        }
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (ObjectUtil.isEmpty(userBaseEntity)) {
            throw new BusinessException("用户未登录");
        }

        List<AiDialoguesTypeEnum> typeEnumList = new ArrayList<>();

        for (String type : typeList) {
            typeEnumList.add(AiDialoguesTypeEnum.getByType(type));
        }

        return aiDialoguesService.getList(typeEnumList, userBaseEntity.getUserId());
    }

    @Override
    public void batchDelete(BatchDelAiDialoguesDto dto) throws Exception {
        Assert.notEmpty(dto.getDialoguesIds(), "对话id列表不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (ObjectUtil.isEmpty(userBaseEntity)) {
            throw new BusinessException("用户未登录");
        }
        aiDialoguesService.batchDelete(dto.getDialoguesIds(), userBaseEntity.getUserId());
    }

    @Override
    public AiDialoguesRecordDto dialoguesDetail(String dialoguesId) throws Exception {
        Assert.notBlank(dialoguesId, "对话id不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (ObjectUtil.isEmpty(userBaseEntity)) {
            throw new BusinessException("用户未登录");
        }
        return aiDialoguesService.dialoguesDetail(dialoguesId, userBaseEntity.getUserId());
    }

    @Override
    public List<DialoguesContextDto> getDialogueContext(String dialogueId) {
        Assert.notBlank(dialogueId);
        return aiDialoguesService.getDialogueContext(dialogueId);
    }

    @Override
    public List<String> questionAssociation(String dialogueId, String question) {
        return aiDialoguesService.questionAssociation(dialogueId, question);
    }

    @Override
    public List<String> guessYouAsk(String type) throws Exception {
        return aiDialoguesService.guessYouAsk(type);
    }

    @Override
    public void call(AiDialoguesCallDto aiDialoguesCallDto) throws Exception {
        Assert.notNull(aiDialoguesCallDto);
        Assert.notBlank(aiDialoguesCallDto.getDialoguesId());
        Assert.notBlank(aiDialoguesCallDto.getInput());
        UserBaseEntity currentUser = BlContext.getCurrentUser();
        aiDialoguesService.call(aiDialoguesCallDto.getDialoguesId(), aiDialoguesCallDto.getInput(), currentUser.getUserId(), aiDialoguesCallDto.getOptions());
    }
}