package cn.com.poc.ai_dialogues.rest.impl;	

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import cn.com.poc.ai_dialogues.rest.BizAiDialoguesProblemAssociationRest;
import cn.com.poc.ai_dialogues.service.BizAiDialoguesProblemAssociationService;
import cn.com.poc.ai_dialogues.dto.BizAiDialoguesProblemAssociationDto;
import cn.com.poc.ai_dialogues.entity.BizAiDialoguesProblemAssociationEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.poc.ai_dialogues.convert.BizAiDialoguesProblemAssociationConvert;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@Component
public class BizAiDialoguesProblemAssociationRestImpl implements BizAiDialoguesProblemAssociationRest {
   
   	@Resource
    private BizAiDialoguesProblemAssociationService service;
    			 
	public BizAiDialoguesProblemAssociationDto getById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
 		return BizAiDialoguesProblemAssociationConvert.entityToDto(service.get(id));
   	}
    
   	public List<BizAiDialoguesProblemAssociationDto> getList(BizAiDialoguesProblemAssociationDto dto,PagingInfo pagingInfo) throws Exception{
       	return service
		        .findByExample(BizAiDialoguesProblemAssociationConvert.dtoToEntity(dto),pagingInfo)
		        .stream()
				.map(BizAiDialoguesProblemAssociationConvert::entityToDto)
				.collect(Collectors.toList());
   	}

   	public BizAiDialoguesProblemAssociationDto save(BizAiDialoguesProblemAssociationDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiDialoguesProblemAssociationEntity entity = BizAiDialoguesProblemAssociationConvert.dtoToEntity(dto);
       	return BizAiDialoguesProblemAssociationConvert.entityToDto(service.save(entity));
   	}
    
	
    public BizAiDialoguesProblemAssociationDto update(BizAiDialoguesProblemAssociationDto dto) throws Exception{
		Assert.notNull(dto);
		BizAiDialoguesProblemAssociationEntity entity = BizAiDialoguesProblemAssociationConvert.dtoToEntity(dto);
       	return BizAiDialoguesProblemAssociationConvert.entityToDto(service.update(entity));
	}

    public void deletedById(java.lang.Long id) throws Exception{
		Assert.notNull(id);
		service.deletedById(id);
	}
}