package cn.com.poc.ai_dialogues.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.ai_dialogues.service.BizAiDialogues3rdRelationService;
import cn.com.poc.ai_dialogues.model.BizAiDialogues3rdRelationModel;
import cn.com.poc.ai_dialogues.entity.BizAiDialogues3rdRelationEntity;
import cn.com.poc.ai_dialogues.convert.BizAiDialogues3rdRelationConvert;
import cn.com.poc.ai_dialogues.repository.BizAiDialogues3rdRelationRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiDialogues3rdRelationServiceImpl extends BaseServiceImpl
 			 implements BizAiDialogues3rdRelationService {
   
   @Resource
   private BizAiDialogues3rdRelationRepository repository;
    			 
   public BizAiDialogues3rdRelationEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiDialogues3rdRelationModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizAiDialogues3rdRelationConvert.modelToEntity(model);
   }

       
   public List<BizAiDialogues3rdRelationEntity> findByExample(BizAiDialogues3rdRelationEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiDialogues3rdRelationEntity> result = new  ArrayList<BizAiDialogues3rdRelationEntity>();
        BizAiDialogues3rdRelationModel model = new BizAiDialogues3rdRelationModel();
        if (example != null){
            model = BizAiDialogues3rdRelationConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAiDialogues3rdRelationModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiDialogues3rdRelationConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiDialogues3rdRelationEntity save(BizAiDialogues3rdRelationEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAiDialogues3rdRelationModel model = BizAiDialogues3rdRelationConvert.entityToModel(entity);
        BizAiDialogues3rdRelationModel saveModel =  this.repository.save(model);
        return BizAiDialogues3rdRelationConvert.modelToEntity(saveModel);
    }

    public BizAiDialogues3rdRelationEntity update(BizAiDialogues3rdRelationEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAiDialogues3rdRelationModel model = this.repository.get(entity.getId());

       if (entity.getDialoguesId() != null){
        model.setDialoguesId(entity.getDialoguesId());
       }
       if (entity.getPlatform() != null){
        model.setPlatform(entity.getPlatform());
       }
       if (entity.getRelationId() != null){
        model.setRelationId(entity.getRelationId());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizAiDialogues3rdRelationModel saveModel =  this.repository.save(model);
        return BizAiDialogues3rdRelationConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiDialogues3rdRelationModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}