package cn.com.poc.ai_dialogues.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.ai_dialogues.service.BizAiDialoguesGuessYouAskService;
import cn.com.poc.ai_dialogues.model.BizAiDialoguesGuessYouAskModel;
import cn.com.poc.ai_dialogues.entity.BizAiDialoguesGuessYouAskEntity;
import cn.com.poc.ai_dialogues.convert.BizAiDialoguesGuessYouAskConvert;
import cn.com.poc.ai_dialogues.repository.BizAiDialoguesGuessYouAskRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAiDialoguesGuessYouAskServiceImpl extends BaseServiceImpl
 			 implements BizAiDialoguesGuessYouAskService {
   
   @Resource
   private BizAiDialoguesGuessYouAskRepository repository;
    			 
   public BizAiDialoguesGuessYouAskEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiDialoguesGuessYouAskModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAiDialoguesGuessYouAskConvert.modelToEntity(model);
   }

       
   public List<BizAiDialoguesGuessYouAskEntity> findByExample(BizAiDialoguesGuessYouAskEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAiDialoguesGuessYouAskEntity> result = new  ArrayList<BizAiDialoguesGuessYouAskEntity>();
        BizAiDialoguesGuessYouAskModel model = new BizAiDialoguesGuessYouAskModel();
        if (example != null){
            model = BizAiDialoguesGuessYouAskConvert.entityToModel(example);
        }
        List<BizAiDialoguesGuessYouAskModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiDialoguesGuessYouAskConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiDialoguesGuessYouAskEntity save(BizAiDialoguesGuessYouAskEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        BizAiDialoguesGuessYouAskModel model = BizAiDialoguesGuessYouAskConvert.entityToModel(entity);
        BizAiDialoguesGuessYouAskModel saveModel =  this.repository.save(model);
        return BizAiDialoguesGuessYouAskConvert.modelToEntity(saveModel);
    }

    public BizAiDialoguesGuessYouAskEntity update(BizAiDialoguesGuessYouAskEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAiDialoguesGuessYouAskModel model = this.repository.get(entity.getId());

       if (entity.getQuestion() != null){
        model.setQuestion(entity.getQuestion());
       }
        BizAiDialoguesGuessYouAskModel saveModel =  this.repository.save(model);
        return BizAiDialoguesGuessYouAskConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizAiDialoguesGuessYouAskModel model =  this.repository.get(id);
        if (model != null){
       }
   }
    
}