package cn.com.poc.ai_dialogues.service.impl;

import cn.com.poc.ai_dialogues.query.ProblemAssociationQueryCondition;
import cn.com.poc.ai_dialogues.query.ProblemAssociationQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.ai_dialogues.service.BizAiDialoguesProblemAssociationService;
import cn.com.poc.ai_dialogues.model.BizAiDialoguesProblemAssociationModel;
import cn.com.poc.ai_dialogues.entity.BizAiDialoguesProblemAssociationEntity;
import cn.com.poc.ai_dialogues.convert.BizAiDialoguesProblemAssociationConvert;
import cn.com.poc.ai_dialogues.repository.BizAiDialoguesProblemAssociationRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAiDialoguesProblemAssociationServiceImpl extends BaseServiceImpl
        implements BizAiDialoguesProblemAssociationService {

    @Resource
    private BizAiDialoguesProblemAssociationRepository repository;

    public BizAiDialoguesProblemAssociationEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAiDialoguesProblemAssociationModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        return BizAiDialoguesProblemAssociationConvert.modelToEntity(model);
    }


    public List<BizAiDialoguesProblemAssociationEntity> findByExample(BizAiDialoguesProblemAssociationEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAiDialoguesProblemAssociationEntity> result = new ArrayList<BizAiDialoguesProblemAssociationEntity>();
        BizAiDialoguesProblemAssociationModel model = new BizAiDialoguesProblemAssociationModel();
        if (example != null) {
            model = BizAiDialoguesProblemAssociationConvert.entityToModel(example);
        }
        List<BizAiDialoguesProblemAssociationModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiDialoguesProblemAssociationConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiDialoguesProblemAssociationEntity save(BizAiDialoguesProblemAssociationEntity entity)  {
        Assert.notNull(entity);
        entity.setId(null);
        BizAiDialoguesProblemAssociationModel model = BizAiDialoguesProblemAssociationConvert.entityToModel(entity);
        BizAiDialoguesProblemAssociationModel saveModel = this.repository.save(model);
        return BizAiDialoguesProblemAssociationConvert.modelToEntity(saveModel);
    }

    public BizAiDialoguesProblemAssociationEntity update(BizAiDialoguesProblemAssociationEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAiDialoguesProblemAssociationModel model = this.repository.get(entity.getId());

        if (entity.getQuestion() != null) {
            model.setQuestion(entity.getQuestion());
        }
        BizAiDialoguesProblemAssociationModel saveModel = this.repository.save(model);
        return BizAiDialoguesProblemAssociationConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAiDialoguesProblemAssociationModel model = this.repository.get(id);
        if (model != null) {
        }
    }

    @Override
    public List<ProblemAssociationQueryItem> getProblemAssociationList(String question) {
        ProblemAssociationQueryCondition condition = new ProblemAssociationQueryCondition();
        condition.setQuestion(question);
        return this.sqlDao.query(condition, ProblemAssociationQueryItem.class);
    }
}