package cn.com.poc.ai_dialogues.service.impl;

import cn.com.poc.ai_dialogues.convert.BizAiDialoguesConvert;
import cn.com.poc.ai_dialogues.entity.BizAiDialoguesEntity;
import cn.com.poc.ai_dialogues.model.BizAiDialoguesModel;
import cn.com.poc.ai_dialogues.query.AiDialoguesQueryCondition;
import cn.com.poc.ai_dialogues.query.AiDialoguesQueryItem;
import cn.com.poc.ai_dialogues.repository.BizAiDialoguesRepository;
import cn.com.poc.ai_dialogues.service.BizAiDialoguesService;
import cn.com.poc.common.utils.UUIDTool;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BizAiDialoguesServiceImpl extends BaseServiceImpl
        implements BizAiDialoguesService {

    @Resource
    private BizAiDialoguesRepository repository;


    @Override
    public String create(String type, Long userId) {
        String dialoguesId = type + "_" + UUIDTool.getUUID();
        BizAiDialoguesModel model = new BizAiDialoguesModel();
        model.setDialoguesId(dialoguesId);
        model.setDialoguesType(type);
        model.setMemberId(userId);
        this.repository.save(model);
        return dialoguesId;
    }


    @Override
    public String create(String type, String fileUrl, Long userId) {
        String dialoguesId = type + "_" + UUIDTool.getUUID();
        BizAiDialoguesModel model = new BizAiDialoguesModel();
        model.setDialoguesId(dialoguesId);
        model.setDialoguesType(type);
        model.setFileUrl(fileUrl);
        model.setMemberId(userId);
        this.repository.save(model);
        return dialoguesId;
    }

    public BizAiDialoguesEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAiDialoguesModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAiDialoguesConvert.modelToEntity(model);
    }


    public List<BizAiDialoguesEntity> findByExample(BizAiDialoguesEntity example, PagingInfo pagingInfo) {
        List<BizAiDialoguesEntity> result = new ArrayList<BizAiDialoguesEntity>();
        BizAiDialoguesModel model = new BizAiDialoguesModel();
        if (example != null) {
            model = BizAiDialoguesConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAiDialoguesModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAiDialoguesConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAiDialoguesEntity save(BizAiDialoguesEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAiDialoguesModel model = BizAiDialoguesConvert.entityToModel(entity);
        BizAiDialoguesModel saveModel = this.repository.save(model);
        return BizAiDialoguesConvert.modelToEntity(saveModel);
    }

    public BizAiDialoguesEntity update(BizAiDialoguesEntity entity) {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAiDialoguesModel model = this.repository.get(entity.getId());

        if (entity.getDialoguesId() != null) {
            model.setDialoguesId(entity.getDialoguesId());
        }
        if (entity.getTitle() != null) {
            model.setTitle(entity.getTitle());
        }
        if (entity.getDialoguesType() != null) {
            model.setDialoguesType(entity.getDialoguesType());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getFileUrl() != null) {
            model.setFileUrl(entity.getFileUrl());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizAiDialoguesModel saveModel = this.repository.save(model);
        return BizAiDialoguesConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAiDialoguesModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }


    @Override
    public List<AiDialoguesQueryItem> queryAiDialoguesQuery(AiDialoguesQueryCondition condition, PagingInfo pagingInfo) throws Exception {
        return this.sqlDao.query(condition, AiDialoguesQueryItem.class, pagingInfo);
    }
}