package cn.com.poc.ai_finance.rest.impl;

import cn.com.poc.ai_finance.aggregate.AiFinanceService;
import cn.com.poc.ai_finance.dto.AiFinanceDialoguesDto;
import cn.com.poc.ai_finance.rest.AiFinanceRest;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2025/6/24
 */
@Component
public class AiFinanceRestImpl implements AiFinanceRest {


    @Resource
    private AiFinanceService aiFinanceService;

    @Override
    public void call(AiFinanceDialoguesDto dto) throws Exception {
        Assert.notNull(dto.getDialoguesId(), "对话id不能为空");
        Assert.notNull(dto.getInput(), "问题不能为空");
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }

        aiFinanceService.call(dto.getDialoguesId(), dto.getInput(), dto.getFileUrl(), dto.getKnowledgeIds(), dto.getDatabaseIds(), userBaseEntity.getUserId());
    }
}
