package cn.com.poc.appbuilder.aggregation;

import com.baidubce.appbuilder.model.appbuilderclient.AppBuilderClientIterator;
import org.springframework.retry.annotation.Retryable;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface AppBuilderService {
    /**
     * 新建对话-【有效期7天】
     *
     * @param appId 应用的ID - app_id
     * @return 返回新建对话的ID - conversation_id
     */
    @Retryable(maxAttempts = 2)
    String conversation(String appId);

    /**
     * 文件上传
     *
     * @param appId          应用的ID - app_id
     * @param conversationId 对话的ID - conversation_id
     * @param file           文件
     * @return 返回文件ID - file_id
     */
    @Retryable(maxAttempts = 2)
    String upload(String appId, String conversationId, MultipartFile file);

    /**
     * 获取用户对话列表-【未过期】
     *
     * @return 返回用户对话列表 - conversation_id
     */
    List<String> getCurrentUserConversationIds();

    /**
     * 大模型对话
     *
     * @param conversationId 对话的ID - conversation_id
     * @param query          查询语句
     * @param fileIds        文件ID列表 - file_id
     * @param stream         true: 流式返回，false: 一次性返回
     */
    AppBuilderClientIterator communication(String conversationId, String query, List<String> fileIds, Boolean stream) throws Exception;
}
