package cn.com.poc.appbuilder.api;

import cn.com.poc.appbuilder.api.base.AppBuilderBaseApi;
import cn.com.poc.appbuilder.api.entity.AppBuilderDescribeListRequest;
import cn.com.poc.appbuilder.api.entity.AppBuilderDescribeRequest;
import cn.com.poc.appbuilder.api.entity.BaiduAppBuilderDescribeAppListResult;
import cn.com.poc.common.utils.http.LocalHttpClient;
import cn.com.yict.framemax.core.exception.BusinessException;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import com.alibaba.fastjson.JSON;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;


/**
 * @Author: Jennie
 * @Description:
 * @Date: 2024/8/7 11:57
 */
@Component
public class BaiduAppBuilderApi implements AppBuilderBaseApi {

    @Resource
    private FmxParamConfigService paramConfigService;

    /**
     * 查询用户应用详情
     */
    public String getDescribeApp(AppBuilderDescribeRequest appBuilderDescribeRequest) {
        String token = paramConfigService.getParam(TOKEN_SITE);
        HttpUriRequest httpUriRequest = RequestBuilder.post()
                .setUri(AppBuilderBaseApi.APP_DESCRIBE_URL)
                .addHeader(AppBuilderBaseApi.jsonHeader)
                .addHeader(HEADER_AUTHORIZATION, "Bearer "+token)
                .setEntity(new StringEntity(JSON.toJSONString(appBuilderDescribeRequest), StandardCharsets.UTF_8))
                .build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, String.class);
//        if (result == null) {
//            throw new BusinessException("获取用户应用详情失败");
//        }
//        if (result.getCode() != null) {
//            throw new BusinessException("获取用户应用详情异常：" + result.getCode() + ":" + result.getMessage());
//        }
//        return result;
    }

    /**
     * 查询用户应用列表
     */
    public BaiduAppBuilderDescribeAppListResult getDescribeAppList(AppBuilderDescribeListRequest appBuilderDescribeListRequest) {
        String token = paramConfigService.getParam(TOKEN_SITE);
        HttpUriRequest httpUriRequest = RequestBuilder.post()
                .setHeader(AppBuilderBaseApi.jsonHeader)
                .setUri(AppBuilderBaseApi.APP_DESCRIBE_LIST_URL)
                .setHeader(HEADER_AUTHORIZATION, "Bearer "+token)
                .setEntity(new StringEntity(JSON.toJSONString(appBuilderDescribeListRequest), StandardCharsets.UTF_8))
                .build();
        BaiduAppBuilderDescribeAppListResult result = LocalHttpClient.executeJsonResult(httpUriRequest, BaiduAppBuilderDescribeAppListResult.class);
        if (result == null) {
            throw new BusinessException("获取用户应用列表失败");
        }
        if (result.getCode() != null) {
            throw new BusinessException("获取用户应用详情异常：" + result.getCode() + ":" + result.getMessage());
        }
        return result;
    }

}
