package cn.com.poc.appbuilder.api.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: Jennie
 * @Description: 千帆AppBuilder 查询用户应用详情响应实体
 * @Date: 2024/8/7 12:00
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BaiduAppBuilderDescribeAppListResult extends BaiduAppBuilderCommonErrorResult implements Serializable {

    /**
     * 请求的id
     */
    private String requestId;

    /**
     * 起始位置
     */
    private String marker;

    /**
     * true表示后面还有数据，false表示已经是最后一页
     */
    private boolean isTruncated;

    /**
     * nextMarker下次查询的起始位置
     */
    private String nextMarker;

    /**
     * 本次查询包含的最大结果集数量
     */
    private int maxKeys;

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getMarker() {
        return marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public boolean isTruncated() {
        return isTruncated;
    }

    public void setTruncated(boolean truncated) {
        isTruncated = truncated;
    }

    public String getNextMarker() {
        return nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public int getMaxKeys() {
        return maxKeys;
    }

    public void setMaxKeys(int maxKeys) {
        this.maxKeys = maxKeys;
    }

    public List<Object> getData() {
        return data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    /**
     * 应用对象列表
     */
    private List<Object> data;
}
