package cn.com.poc.appbuilder.api.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: Jennie
 * @Description:
 * @Date: 2024/8/7 12:11
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class KnowledgeBaseConfig implements Serializable {

    /**
     * 知识库列表
     */
    private List<KnowledgeBase> knowledgeBases;

    /**
     * 检索配置
     */
    private RetrievalConfig retrieval;

    public List<KnowledgeBase> getKnowledgeBases() {
        return knowledgeBases;
    }

    public void setKnowledgeBases(List<KnowledgeBase> knowledgeBases) {
        this.knowledgeBases = knowledgeBases;
    }

    public RetrievalConfig getRetrieval() {
        return retrieval;
    }

    public void setRetrieval(RetrievalConfig retrieval) {
        this.retrieval = retrieval;
    }
}
