package cn.com.poc.appbuilder.api.entity;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

/**
 * @Author: Jennie
 * @Description:
 * @Date: 2024/8/7 12:11
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RetrievalConfig implements Serializable {

    /**
     * 是否开启百度搜索
     */
    private boolean enableWebSearch;

    /**
     * 排序策略(Combined | RagFirst | WebSearchFirst), enableWebSearch 等于true时生效
     */
    private String order;

    /**
     * 检索策略(Advanced | Fulltext | Semantic)
     */
    private String strategy;

    /**
     * 召回数量
     */
    private int topK;

    /**
     * 阈值
     */
    private float threshold;

    public boolean isEnableWebSearch() {
        return enableWebSearch;
    }

    public void setEnableWebSearch(boolean enableWebSearch) {
        this.enableWebSearch = enableWebSearch;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public int getTopK() {
        return topK;
    }

    public void setTopK(int topK) {
        this.topK = topK;
    }

    public float getThreshold() {
        return threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

}
